/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.gateway.filter.factory.RetryGatewayFilterFactoryIntegrationTests;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@EnableAutoConfiguration
@SpringBootConfiguration
@Import(value={BaseWebClientTests.DefaultTestConfig.class})
@RestController
@LoadBalancerClient(name="badservice", configuration={RetryGatewayFilterFactoryIntegrationTests.TestBadLoadBalancerConfig.class})
public class SpringCloudCircuitBreakerTestConfig {
    @Value(value="${test.uri}")
    private String uri;

    @GetMapping(value={"/circuitbreakerFallbackController"})
    public Map<String, String> fallbackcontroller(@RequestParam(value="a") String a) {
        return Collections.singletonMap("from", "circuitbreakerfallbackcontroller");
    }

    @GetMapping(value={"/circuitbreakerUriFallbackController/**"})
    public Map<String, String> uriFallbackcontroller(ServerWebExchange exchange, @RequestParam(value="a") String a) {
        return Collections.singletonMap("uri", exchange.getRequest().getURI().toString());
    }

    @GetMapping(value={"/circuitbreakerFallbackController2"})
    public Map<String, String> fallbackcontroller2() {
        return Collections.singletonMap("from", "circuitbreakerfallbackcontroller2");
    }

    @GetMapping(value={"/circuitbreakerFallbackController3"})
    public Map<String, String> fallbackcontroller3() {
        return Collections.singletonMap("from", "circuitbreakerfallbackcontroller3");
    }

    @GetMapping(value={"/statusCodeFallbackController"})
    public Map<String, String> statusCodeFallbackController(ServerWebExchange exchange) {
        return Collections.singletonMap("from", "statusCodeFallbackController");
    }

    @RequestMapping(value={"/resetExchangeFallbackController"})
    public ResponseEntity<Map<String, String>> resetExchangeFallbackController(ServerWebExchange exchange) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.OK).headers(exchange.getRequest().getHeaders().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("X-Test-")).map(entry -> new AbstractMap.SimpleEntry<CallSite, List>((CallSite)((Object)((String)entry.getKey() + "-fallback")), (List)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (list1, list2) -> Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toList()), HttpHeaders::new)))).body(Collections.singletonMap("from", "resetExchangeFallbackController"));
    }

    @Bean
    public RouteLocator circuitBreakerRouteLocator(RouteLocatorBuilder builder) {
        return builder.routes().route("fallback_controller_3", r -> r.path(new String[]{"/fallback"}).filters(f -> f.setPath("/circuitbreakerFallbackController3")).uri(this.uri)).route("circuitbreaker_fallback_forward", r -> r.host(new String[]{"**.circuitbreakerforward.org"}).filters(f -> f.circuitBreaker(config -> config.setFallbackUri("forward:/fallback"))).uri(this.uri)).route("circuitbreaker_java", r -> r.host(new String[]{"**.circuitbreakerjava.org"}).filters(f -> f.prefixPath("/httpbin").circuitBreaker(config -> config.setFallbackUri("forward:/circuitbreakerFallbackController2"))).uri(this.uri)).route("circuitbreaker_connection_failure", r -> r.host(new String[]{"**.circuitbreakerconnectfail.org"}).filters(f -> f.prefixPath("/httpbin").circuitBreaker(config -> {})).uri(this.uri)).route("circuitbreaker_response_stall", r -> r.host(new String[]{"**.circuitbreakerresponsestall.org"}).filters(f -> f.prefixPath("/httpbin").circuitBreaker(config -> config.setName("stalling-command"))).uri(this.uri)).route("circuitbreaker_fallback_test_reset_exchange", r -> r.host(new String[]{"**.circuitbreakerresetexchange.org"}).filters(f -> f.circuitBreaker(config -> config.setName("fallbackcmd").setFallbackUri("forward:/resetExchangeFallbackController")).filter((exchange, chain) -> chain.filter(exchange).then(Mono.defer(() -> !exchange.getResponse().isCommitted() ? Mono.error((Throwable)new Exception("Some Random Exception")) : Mono.empty())))).uri(this.uri)).build();
    }

    @Bean
    CircuitBreakerExceptionFallbackHandler exceptionFallbackHandler() {
        return new CircuitBreakerExceptionFallbackHandler();
    }

    @Bean
    RouterFunction<ServerResponse> routerFunction(CircuitBreakerExceptionFallbackHandler exceptionFallbackHandler) {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.GET((String)"/circuitbreakerExceptionFallback"), exceptionFallbackHandler::retrieveExceptionInfo);
    }

    private static class CircuitBreakerExceptionFallbackHandler {
        static final String RETRIEVED_EXCEPTION = "Retrieved-Exception";

        private CircuitBreakerExceptionFallbackHandler() {
        }

        Mono<ServerResponse> retrieveExceptionInfo(ServerRequest serverRequest) {
            String exceptionName = serverRequest.attribute(ServerWebExchangeUtils.CIRCUITBREAKER_EXECUTION_EXCEPTION_ATTR).map(exception -> exception.getClass().getName()).orElse("");
            return ((ServerResponse.BodyBuilder)ServerResponse.ok().header(RETRIEVED_EXCEPTION, new String[]{exceptionName})).build();
        }
    }
}

