/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.GZIPOutputStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.filter.factory.cache.CachedResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;

class CachedResponseTest {
    CachedResponseTest() {
    }

    @Test
    void bodyAsByteArray_whenEmptyBody() throws IOException {
        CachedResponse cachedResponse = CachedResponse.create((HttpStatusCode)HttpStatus.OK).build();
        byte[] asByteArray = cachedResponse.bodyAsByteArray();
        Assertions.assertThat((byte[])asByteArray).isEmpty();
    }

    @Test
    void bodyAsByteArray_whenThereIsContent() throws IOException {
        String body = "example";
        CachedResponse cachedResponse = CachedResponse.create((HttpStatusCode)HttpStatus.OK).body(body).build();
        byte[] asByteArray = cachedResponse.bodyAsByteArray();
        Assertions.assertThat((byte[])asByteArray).isEqualTo((Object)body.getBytes());
    }

    @Test
    void bodyAsString_whenEmptyBody() throws IOException {
        CachedResponse cachedResponse = CachedResponse.create((HttpStatusCode)HttpStatus.OK).build();
        String asString = cachedResponse.bodyAsString();
        Assertions.assertThat((String)asString).isEmpty();
    }

    @Test
    void bodyAsString_whenThereIsContent() throws IOException {
        String body = "example";
        CachedResponse cachedResponse = CachedResponse.create((HttpStatusCode)HttpStatus.OK).body(body).build();
        String asString = cachedResponse.bodyAsString();
        Assertions.assertThat((String)asString).isEqualTo(body);
    }

    @Test
    void bodyAsString_whenThereIsGZipContent() throws IOException {
        String body = "example";
        CachedResponse cachedResponse = CachedResponse.create((HttpStatusCode)HttpStatus.OK).header("Content-Encoding", "gzip").appendToBody(this.convertToGzip(body)).build();
        String asString = cachedResponse.bodyAsString();
        Assertions.assertThat((String)asString).isEqualTo(body);
    }

    private ByteBuffer convertToGzip(String str) throws IOException {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        GZIPOutputStream outGzip = new GZIPOutputStream(outBytes);
        outGzip.write(str.getBytes());
        outGzip.close();
        return ByteBuffer.wrap(outBytes.toByteArray());
    }
}

