/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import java.util.UUID;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;

@DirtiesContext
@ActiveProfiles(profiles={"local-cache-filter"})
public class LocalResponseCacheGlobalFilterTests {
    private static final String CUSTOM_HEADER = "X-Custom-Date";

    @Nested
    @SpringBootTest(properties={"spring.cloud.gateway.filter.local-response-cache.enabled=true"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    public class GlobalCacheEnabled
    extends BaseWebClientTests {
        @Test
        void shouldGlobalCacheResponseWhenRouteDoesNotHaveFilter() {
            String uri = "/" + UUID.randomUUID() + "/global-cache/headers";
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGlobalFilterTests.CUSTOM_HEADER, new String[]{"1"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date");
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGlobalFilterTests.CUSTOM_HEADER, new String[]{"2"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date").isEqualTo((Object)"1");
        }

        @Test
        void shouldNotReturnPragmaHeaderInNonCachedAndCachedResponses() {
            this.shouldNotReturnHeader("Pragma");
        }

        @Test
        void shouldNotReturnExpiresHeaderInNonCachedAndCachedResponses() {
            this.shouldNotReturnHeader("Expires");
        }

        private void shouldNotReturnHeader(String header) {
            String uri = "/" + UUID.randomUUID() + "/global-cache/headers";
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).exchange().expectHeader().doesNotExist(header);
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).exchange().expectHeader().doesNotExist(header);
        }

        @EnableAutoConfiguration
        @SpringBootConfiguration
        @Import(value={BaseWebClientTests.DefaultTestConfig.class})
        public static class TestConfig {
            @Value(value="${test.uri}")
            String uri;

            @Bean
            public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
                return builder.routes().route("global_local_response_cache_java_test", r -> r.path(new String[]{"/{namespace}/global-cache/**"}).and().host(new String[]{"{sub}.localresponsecache.org"}).filters(f -> f.stripPrefix(2).prefixPath("/httpbin")).uri(this.uri)).build();
            }
        }
    }

    @Nested
    @SpringBootTest(properties={"spring.cloud.gateway.filter.local-response-cache.enabled=true", "spring.cloud.gateway.global-filter.local-response-cache.enabled=false"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    public class GlobalCacheNotEnabled
    extends BaseWebClientTests {
        @Test
        void shouldNotCacheResponseWhenGlobalIsNotEnabled() {
            String uri = "/" + UUID.randomUUID() + "/global-cache-deactivated/headers";
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGlobalFilterTests.CUSTOM_HEADER, new String[]{"1"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date");
            this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{"www.localresponsecache.org"}).header(LocalResponseCacheGlobalFilterTests.CUSTOM_HEADER, new String[]{"2"}).exchange().expectBody().jsonPath("$.headers.X-Custom-Date").isEqualTo((Object)"2");
        }

        @EnableAutoConfiguration
        @SpringBootConfiguration
        @Import(value={BaseWebClientTests.DefaultTestConfig.class})
        public static class TestConfig {
            @Value(value="${test.uri}")
            String uri;

            @Bean
            public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
                return builder.routes().route("global_local_response_cache_deactivated_java_test", r -> r.path(new String[]{"/{namespace}/global-cache-deactivated/**"}).and().host(new String[]{"{sub}.localresponsecache.org"}).filters(f -> f.stripPrefix(2).prefixPath("/httpbin")).uri(this.uri)).build();
            }
        }
    }
}

