/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache.keygenerator;

import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.filter.factory.cache.keygenerator.CacheKeyGenerator;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.util.MultiValueMap;

class DefaultKeyValueGeneratorTests {
    DefaultKeyValueGeneratorTests() {
    }

    @Test
    void uriAuthorizationAndCookiesArePresent() {
        String uri = "http://myuri";
        HttpHeaders headers = new HttpHeaders();
        String authorization = "my-auth";
        headers.set("Authorization", authorization);
        String cookieName = "my-cookie";
        String cookieValue = "cookie-value";
        HttpCookie cookie = new HttpCookie(cookieName, cookieValue);
        MockServerHttpRequest request = MockServerHttpRequest.get((String)uri, (Object[])new Object[0]).cookie(new HttpCookie[]{cookie}).headers((MultiValueMap)headers).build();
        String result = this.apply((ServerHttpRequest)request);
        Assertions.assertThat((String)result).isEqualTo(uri + ";Authorization=" + authorization + ";" + cookieName + "=" + cookieValue);
    }

    @Test
    void uriAndCookiesArePresent() {
        String uri = "http://myuri";
        HttpHeaders headers = new HttpHeaders();
        String cookieName = "my-cookie";
        String cookieValue = "cookie-value";
        HttpCookie cookie = new HttpCookie(cookieName, cookieValue);
        MockServerHttpRequest request = MockServerHttpRequest.get((String)uri, (Object[])new Object[0]).cookie(new HttpCookie[]{cookie}).headers((MultiValueMap)headers).build();
        String result = this.apply((ServerHttpRequest)request);
        Assertions.assertThat((String)result).isEqualTo(uri + ";;" + cookieName + "=" + cookieValue);
    }

    @Test
    void onlyUriPresent() {
        String uri = "http://myuri";
        MockServerHttpRequest request = MockServerHttpRequest.get((String)uri, (Object[])new Object[0]).build();
        String result = this.apply((ServerHttpRequest)request);
        Assertions.assertThat((String)result).isEqualTo(uri + ";;");
    }

    public String apply(ServerHttpRequest request) {
        return CacheKeyGenerator.DEFAULT_KEY_VALUE_GENERATORS.stream().map(generator -> generator.apply(request)).collect(Collectors.joining(";"));
    }
}

