/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache.postprocessor;

import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.springframework.cloud.gateway.filter.factory.cache.postprocessor.SetCacheDirectivesByMaxAgeAfterCacheExchangeMutator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.http.server.reactive.MockServerHttpResponse;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

class SetCacheDirectivesByMaxAgeAfterCacheExchangeMutatorTests {
    private MockServerWebExchange inputExchange;
    private SetCacheDirectivesByMaxAgeAfterCacheExchangeMutator toTest;

    SetCacheDirectivesByMaxAgeAfterCacheExchangeMutatorTests() {
    }

    @BeforeEach
    void setUp() {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setCacheControl("max-age=1234");
        MockServerHttpRequest httpRequest = MockServerHttpRequest.get((String)"https://this", (Object[])new Object[0]).build();
        this.inputExchange = MockServerWebExchange.from((MockServerHttpRequest)httpRequest);
        MockServerHttpResponse httpResponse = this.inputExchange.getResponse();
        httpResponse.setStatusCode((HttpStatusCode)HttpStatus.OK);
        httpResponse.getHeaders().putAll((Map)responseHeaders);
        this.toTest = new SetCacheDirectivesByMaxAgeAfterCacheExchangeMutator();
    }

    @ParameterizedTest
    @ValueSource(strings={"", "ETag=1234-123", "s-max-age=20"})
    void doesntModifyCacheControlWhenNoMaxAge(String cacheControlValue) {
        this.inputExchange.getResponse().getHeaders().setCacheControl(cacheControlValue);
        this.toTest.accept((ServerWebExchange)this.inputExchange, null);
        Assertions.assertThat((String)this.inputExchange.getResponse().getHeaders().getCacheControl()).isEqualTo(cacheControlValue);
    }

    @ParameterizedTest
    @ValueSource(strings={"max-age=0", "ETag=1234-123,max-age=0", "s-max-age=20,max-age=0", "ETag=with-spaces, max-age=0", "ETag=with-spaces, max-age=0,Expires=123123123", " max-age=0, ETag=with-spaces"})
    void directivesNoCacheAreAddedWhenMaxAgeIsZero(String cacheControlValue) {
        this.inputExchange.getResponse().getHeaders().setCacheControl(cacheControlValue);
        this.toTest.accept((ServerWebExchange)this.inputExchange, null);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)this.inputExchange.getResponse().getHeaders().getCacheControl()).doesNotContainPattern((CharSequence)",\\s*,")).contains(new CharSequence[]{"max-age=0"})).contains(new CharSequence[]{"must-revalidate"})).contains(new CharSequence[]{"no-cache"});
    }

    @ParameterizedTest
    @ValueSource(strings={"max-age=10,must-revalidate", "must-revalidate,ETag=1234-123,max-age=10", "must-revalidate,s-max-age=0,max-age=10", " max-age=10, must-revalidate,ETag=with-spaces", "ETag=with-spaces,must-revalidate, max-age=10,Expires=123123123", "ETag=with-spaces,must-revalidate, max-age=10", "max-age=10,no-store"})
    void directivesNoCacheAreRemovedWhenMaxAgePositive(String cacheControlValue) {
        this.inputExchange.getResponse().getHeaders().setCacheControl(cacheControlValue);
        this.toTest.accept((ServerWebExchange)this.inputExchange, null);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)this.inputExchange.getResponse().getHeaders().getCacheControl()).contains(new CharSequence[]{"max-age=10"})).doesNotContainPattern((CharSequence)",\\s*,")).doesNotContain(new CharSequence[]{"no-store"})).doesNotContain(new CharSequence[]{"must-revalidate"})).doesNotContain(new CharSequence[]{"no-cache"});
    }
}

