/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.PermitAllSecurityConfiguration;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.ServiceInstanceListSuppliers;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.log.LogMessage;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@SpringBootTest(properties={}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"transferencoding"})
public class TransferEncodingNormalizationHeadersFilterIntegrationTests {
    private static final Log log = LogFactory.getLog(TransferEncodingNormalizationHeadersFilterIntegrationTests.class);
    @LocalServerPort
    private int port;

    @Test
    void legitRequestShouldNotFail() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.assert200With("Should Fail", StreamUtils.copyToByteArray((InputStream)classLoader.getResourceAsStream("transfer-encoding/invalid-request.bin")));
        this.assert200With("Should Not Fail", StreamUtils.copyToByteArray((InputStream)classLoader.getResourceAsStream("transfer-encoding/valid-request.bin")));
    }

    private void assert200With(String name, byte[] payload) throws Exception {
        String response = this.execute("localhost", this.port, payload);
        log.info((Object)LogMessage.format((String)"Request to localhost:%d %s\n%s", (Object)this.port, (Object)name, (Object)new String(payload)));
        Assertions.assertThat((String)response).isNotNull();
        log.info((Object)LogMessage.format((String)"Response %s\n%s", (Object)name, (Object)response));
        Assertions.assertThat((String)response).matches((CharSequence)"HTTP/1.\\d 200 OK");
    }

    private String execute(String target, int port, byte[] payload) throws IOException {
        Socket socket = new Socket(target, port);
        OutputStream out = socket.getOutputStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        out.write(payload);
        String headResponse = in.readLine();
        out.close();
        in.close();
        return headResponse;
    }

    public static class TestLoadBalancerConfig {
        @LocalServerPort
        protected int port = 0;

        @Bean
        public ServiceInstanceListSupplier staticServiceInstanceListSupplier() {
            return ServiceInstanceListSuppliers.from((String)"xferenc", (ServiceInstance[])new ServiceInstance[]{new DefaultServiceInstance("xferenc-1", "xferenc", "localhost", this.port, false)});
        }
    }

    public static class Message {
        private String message;

        public Message(@JsonProperty(value="message") String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={PermitAllSecurityConfiguration.class})
    @LoadBalancerClient(name="xferenc", configuration={TestLoadBalancerConfig.class})
    @RestController
    public static class TestConfig {
        @PostMapping(value={"/echo"}, produces={"application/json"})
        public Message message(@RequestBody Message message) throws IOException {
            return message;
        }

        @Bean
        public RouteLocator routeLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("echo", r -> r.path(new String[]{"/route/echo"}).filters(f -> f.stripPrefix(1)).uri("lb://xferenc")).build();
        }
    }
}

