/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.filter.headers.XForwardedHeadersFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;

public class XForwardedHeadersFilterTests {
    @Test
    public void remoteAddressIsNull() throws Exception {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost:8080/get", (Object[])new Object[0]).header("Host", new String[]{"myhost"}).build();
        XForwardedHeadersFilter filter = new XForwardedHeadersFilter();
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((Map)headers).containsKeys((Object[])new String[]{"X-Forwarded-Host", "X-Forwarded-Port", "X-Forwarded-Proto"});
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Host")).isEqualTo("localhost:8080");
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Port")).isEqualTo("8080");
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Proto")).isEqualTo("http");
    }

    @Test
    public void xForwardedHeadersDoNotExist() throws Exception {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost:8080/get", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 80)).header("Host", new String[]{"myhost"}).build();
        XForwardedHeadersFilter filter = new XForwardedHeadersFilter();
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((Map)headers).containsKeys((Object[])new String[]{"X-Forwarded-For", "X-Forwarded-Host", "X-Forwarded-Port", "X-Forwarded-Proto"});
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-For")).isEqualTo("10.0.0.1");
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Host")).isEqualTo("localhost:8080");
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Port")).isEqualTo("8080");
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Proto")).isEqualTo("http");
    }

    @Test
    public void defaultPort() throws Exception {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 80)).header("Host", new String[]{"myhost"}).build();
        XForwardedHeadersFilter filter = new XForwardedHeadersFilter();
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((Map)headers).containsKeys((Object[])new String[]{"X-Forwarded-For", "X-Forwarded-Host", "X-Forwarded-Port", "X-Forwarded-Proto"});
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-For")).isEqualTo("10.0.0.1");
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Host")).isEqualTo("localhost");
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Port")).isEqualTo("80");
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Proto")).isEqualTo("http");
    }

    @Test
    public void appendsValues() throws Exception {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost:8080/get", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 80)).header("X-Forwarded-For", new String[]{"192.168.0.2"}).header("X-Forwarded-Host", new String[]{"example.com"}).header("X-Forwarded-Port", new String[]{"443"}).header("X-Forwarded-Proto", new String[]{"https"}).build();
        XForwardedHeadersFilter filter = new XForwardedHeadersFilter();
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((Map)headers).containsKeys((Object[])new String[]{"X-Forwarded-For", "X-Forwarded-Host", "X-Forwarded-Port", "X-Forwarded-Proto"});
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-For")).isEqualTo("192.168.0.2,10.0.0.1");
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Host")).isEqualTo("example.com,localhost:8080");
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Port")).isEqualTo("443,8080");
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Proto")).isEqualTo("https,http");
    }

    @Test
    public void appendDisabled() throws Exception {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost:8080/get", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 80)).header("X-Forwarded-For", new String[]{"192.168.0.2"}).header("X-Forwarded-Host", new String[]{"example.com"}).header("X-Forwarded-Port", new String[]{"443"}).header("X-Forwarded-Proto", new String[]{"https"}).header("X-Forwarded-Prefix", new String[]{"/prefix"}).build();
        XForwardedHeadersFilter filter = new XForwardedHeadersFilter();
        filter.setForAppend(false);
        filter.setHostAppend(false);
        filter.setPortAppend(false);
        filter.setProtoAppend(false);
        filter.setPrefixAppend(false);
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((Map)headers).containsKeys((Object[])new String[]{"X-Forwarded-For", "X-Forwarded-Host", "X-Forwarded-Port", "X-Forwarded-Proto", "X-Forwarded-Prefix"});
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-For")).isEqualTo("10.0.0.1");
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Host")).isEqualTo("localhost:8080");
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Port")).isEqualTo("8080");
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Proto")).isEqualTo("http");
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Prefix")).isEqualTo("/prefix");
    }

    @Test
    public void prefixToInfer() throws Exception {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"https://originalhost:8080/prefix/get", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 80)).build();
        XForwardedHeadersFilter filter = new XForwardedHeadersFilter();
        filter.setPrefixAppend(true);
        filter.setPrefixEnabled(true);
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        LinkedHashSet<URI> originalUris = new LinkedHashSet<URI>();
        originalUris.add(UriComponentsBuilder.fromUriString((String)"https://originalhost:8080/prefix/get/").build().toUri());
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR, originalUris);
        URI requestUri = UriComponentsBuilder.fromUriString((String)"https://routedservice:8090/get").build().toUri();
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, requestUri);
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)exchange);
        Assertions.assertThat((Map)headers).containsKeys((Object[])new String[]{"X-Forwarded-Prefix"});
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Prefix")).isEqualTo("/prefix");
    }

    @Test
    public void prefixToInferWhenEqualsResource() throws Exception {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"https://originalhost:8080/resource/resource/", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 80)).build();
        XForwardedHeadersFilter filter = new XForwardedHeadersFilter();
        filter.setPrefixAppend(true);
        filter.setPrefixEnabled(true);
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        LinkedHashSet<URI> originalUris = new LinkedHashSet<URI>();
        originalUris.add(UriComponentsBuilder.fromUriString((String)"https://originalhost:8080/resource/resource/").build().toUri());
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR, originalUris);
        URI requestUri = UriComponentsBuilder.fromUriString((String)"https://routedservice:8090/resource").build().toUri();
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, requestUri);
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)exchange);
        Assertions.assertThat((Map)headers).containsKeys((Object[])new String[]{"X-Forwarded-Prefix"});
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Prefix")).isEqualTo("/resource");
    }

    @Test
    public void prefixAddedWithoutTrailingSlash() throws Exception {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"https://originalhost:8080/foo/bar", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 80)).build();
        XForwardedHeadersFilter filter = new XForwardedHeadersFilter();
        filter.setPrefixAppend(true);
        filter.setPrefixEnabled(true);
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        LinkedHashSet<URI> originalUris = new LinkedHashSet<URI>();
        originalUris.add(UriComponentsBuilder.fromUriString((String)"https://originalhost:8080/foo/bar").build().toUri());
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR, originalUris);
        URI requestUri = UriComponentsBuilder.fromUriString((String)"https://routedservice:8090/").build().toUri();
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, requestUri);
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)exchange);
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-Prefix")).isEqualTo("/foo/bar");
    }

    @Test
    public void noPrefixToInfer() throws Exception {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"https://originalhost:8080/get", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 80)).build();
        XForwardedHeadersFilter filter = new XForwardedHeadersFilter();
        filter.setPrefixAppend(true);
        filter.setPrefixEnabled(true);
        filter.setForEnabled(false);
        filter.setHostEnabled(false);
        filter.setPortEnabled(false);
        filter.setProtoEnabled(false);
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        LinkedHashSet<URI> originalUris = new LinkedHashSet<URI>();
        originalUris.add(UriComponentsBuilder.fromUriString((String)"https://originalhost:8080/get/").build().toUri());
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR, originalUris);
        URI requestUri = UriComponentsBuilder.fromUriString((String)"https://routedservice:8090/get").build().toUri();
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, requestUri);
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)exchange);
        Assertions.assertThat((Map)headers).isEmpty();
    }

    @Test
    public void routedPathInRequestPathButNotPrefix() throws Exception {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"https://originalhost:8080/get", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 80)).build();
        XForwardedHeadersFilter filter = new XForwardedHeadersFilter();
        filter.setPrefixAppend(true);
        filter.setPrefixEnabled(true);
        filter.setForEnabled(false);
        filter.setHostEnabled(false);
        filter.setPortEnabled(false);
        filter.setProtoEnabled(false);
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        LinkedHashSet<URI> originalUris = new LinkedHashSet<URI>();
        originalUris.add(UriComponentsBuilder.fromUriString((String)"https://originalhost:8080/one/two/three").build().toUri());
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR, originalUris);
        URI requestUri = UriComponentsBuilder.fromUriString((String)"https://routedservice:8090/two").build().toUri();
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, requestUri);
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)exchange);
        Assertions.assertThat((Map)headers).isEmpty();
    }

    @Test
    public void allDisabled() throws Exception {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost:8080/get", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 80)).build();
        XForwardedHeadersFilter filter = new XForwardedHeadersFilter();
        filter.setForEnabled(false);
        filter.setHostEnabled(false);
        filter.setPortEnabled(false);
        filter.setProtoEnabled(false);
        filter.setPrefixEnabled(false);
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((Map)headers).isEmpty();
    }

    @Test
    public void allowDuplicateEntriesInXForwardedForHeader() throws Exception {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost:8080/get", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 80)).header("X-Forwarded-For", new String[]{"10.0.0.1"}).build();
        XForwardedHeadersFilter filter = new XForwardedHeadersFilter();
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((Map)headers).containsKeys((Object[])new String[]{"X-Forwarded-For"});
        Assertions.assertThat((String)headers.getFirst("X-Forwarded-For")).isEqualTo("10.0.0.1,10.0.0.1");
    }

    @Test
    public void nullValuesSkipped() throws Exception {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"/get", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 80)).header("X-Forwarded-For", new String[]{"10.0.0.1"}).build();
        XForwardedHeadersFilter filter = new XForwardedHeadersFilter();
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((Map)headers).doesNotContainKeys((Object[])new String[]{"X-Forwarded-Proto", "X-Forwarded-Host"});
    }
}

