/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers.observation;

import io.micrometer.observation.Observation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.cloud.gateway.filter.headers.observation.ObservationClosingWebExceptionHandler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

class ObservationClosingWebExceptionHandlerTests {
    ObservationClosingWebExceptionHandler handler = new ObservationClosingWebExceptionHandler();
    MockServerHttpRequest request = MockServerHttpRequest.get((String)"/get", (Object[])new Object[0]).build();
    ServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)this.request);

    ObservationClosingWebExceptionHandlerTests() {
    }

    @Test
    void shouldDoNothingWhenObservationAlreadyStopped() {
        this.exchange.getAttributes().put("gateway.observation.stopped", "true");
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_OBSERVATION_ATTR, "if this attribute will be attempted to be retrieved ClassCast will be thrown");
        Assertions.assertThatNoException().isThrownBy(() -> this.handler.handle(this.exchange, (Throwable)new RuntimeException()));
    }

    @Test
    void shouldDoNothingWhenThereIsNoObservation() {
        Assertions.assertThatNoException().isThrownBy(() -> this.handler.handle(this.exchange, (Throwable)new RuntimeException()));
    }

    @Test
    void shouldStopTheObservationIfItWasNotStoppedPreviouslyAndThereWasAnError() {
        Observation observation = (Observation)Mockito.mock(Observation.class);
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_OBSERVATION_ATTR, observation);
        RuntimeException runtimeException = new RuntimeException();
        Assertions.assertThatNoException().isThrownBy(() -> this.handler.handle(this.exchange, (Throwable)runtimeException));
        ((Observation)Mockito.verify((Object)observation)).error((Throwable)runtimeException);
        ((Observation)Mockito.verify((Object)observation)).stop();
    }
}

