/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers.observation;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.tck.MeterRegistryAssert;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.test.SampleTestRunner;
import io.micrometer.tracing.test.reporter.BuildingBlocks;
import io.micrometer.tracing.test.simple.SpansAssert;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.function.BiConsumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayPropagatingSenderTracingObservationHandler;
import org.springframework.cloud.gateway.filter.headers.observation.ObservedRequestHttpHeadersFilter;
import org.springframework.cloud.gateway.filter.headers.observation.ObservedResponseHttpHeadersFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import reactor.util.context.Context;

public class ObservedHttpHeadersFilterTests
extends SampleTestRunner {
    ObservedHttpHeadersFilterTests() {
        super(SampleTestRunner.SampleRunnerConfig.builder().build());
    }

    public SampleTestRunner.TracingSetup[] getTracingSetup() {
        return new SampleTestRunner.TracingSetup[]{SampleTestRunner.TracingSetup.IN_MEMORY_BRAVE, SampleTestRunner.TracingSetup.ZIPKIN_BRAVE};
    }

    public SampleTestRunner.SampleTestRunnerConsumer yourCode() throws Exception {
        return (bb, meterRegistry) -> {
            MockServerHttpRequest.BaseBuilder builder = MockServerHttpRequest.get((String)"http://localhost:8080/{foo}", (Object[])new Object[]{"get"}).header("X-A", new String[]{"aValue"});
            TraceContext context = bb.getTracer().currentTraceContext().context();
            bb.getPropagator().inject(context, (Object)builder, (b, k, v) -> b.header(k, new String[]{v}));
            MockServerHttpRequest request = builder.build();
            MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
            ServerWebExchangeUtils.putUriTemplateVariables((ServerWebExchange)exchange, Map.of("foo", "get"));
            Route route = ((Route.AsyncBuilder)((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("foo")).uri("http://localhost:8080/")).order(1)).predicate(serverWebExchange -> true).build();
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR, route);
            Context ctx = Context.of(Map.of("micrometer.observation", this.getObservationRegistry().getCurrentObservation()));
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REACTOR_CONTEXT_ATTR, ctx);
            exchange.getResponse().setStatusCode(HttpStatusCode.valueOf((int)200));
            HttpHeaders headers = new ObservedRequestHttpHeadersFilter(this.getObservationRegistry()).filter(request.getHeaders(), (ServerWebExchange)exchange);
            headers = new ObservedResponseHttpHeadersFilter().filter(headers, (ServerWebExchange)exchange);
            Assertions.assertThat((String)((String)exchange.getAttribute("gateway.observation.stopped"))).isNotNull();
            ((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)headers).containsEntry((Object)"X-A", Collections.singletonList("aValue"))).containsEntry((Object)"X-B3-Sampled", Collections.singletonList("1"))).containsEntry((Object)"X-B3-TraceId", Collections.singletonList(context.traceId()))).doesNotContainEntry((Object)"X-B3-SpanId", Collections.singletonList(context.spanId()))).containsKey((Object)"X-B3-SpanId");
            SpansAssert.then((Collection)bb.getFinishedSpans()).hasASpanWithName("HTTP GET", spanAssert -> spanAssert.hasTag("http.method", "GET").hasTag("http.status_code", "200").hasTag("http.uri", "http://localhost:8080/get").hasTag("spring.cloud.gateway.route.uri", "http://localhost:8080/").hasTag("spring.cloud.gateway.route.id", "foo"));
            MeterRegistryAssert.then((MeterRegistry)meterRegistry).hasTimerWithNameAndTags("http.client.requests", Tags.of((String[])new String[]{"spring.cloud.gateway.route.id", "foo", "error", "none", "http.method", "GET", "http.status_code", "200", "spring.cloud.gateway.route.uri", "http://localhost:8080/"})).hasMeterWithNameAndTags("http.client.requests.active", Tags.of((String[])new String[]{"spring.cloud.gateway.route.id", "foo", "http.method", "GET", "spring.cloud.gateway.route.uri", "http://localhost:8080/"}));
        };
    }

    public BiConsumer<BuildingBlocks, Deque<ObservationHandler<? extends Observation.Context>>> customizeObservationHandlers() {
        return (bb, observationHandlers) -> observationHandlers.addFirst(new GatewayPropagatingSenderTracingObservationHandler(bb.getTracer(), bb.getPropagator(), Collections.emptyList()));
    }
}

