/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.ratelimit;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.test.context.DynamicPropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@SpringBootTest
@DirtiesContext
@Testcontainers
@Tag(value="DockerRequired")
public class RedisRateLimiterLuaScriptTests {
    static final String KEY_PREFIX = "redis-rate-limiter-lua-script-tests";
    @Container
    public static GenericContainer redis = new GenericContainer("redis:5.0.14-alpine").withExposedPorts(new Integer[]{6379});
    @Autowired
    ReactiveStringRedisTemplate redisTemplate;
    @Autowired
    RedisScript<List<Long>> redisScript;

    @DynamicPropertySource
    static void containerProperties(DynamicPropertyRegistry registry) {
        registry.add("spring.data.redis.host", () -> ((GenericContainer)redis).getContainerIpAddress());
        registry.add("spring.data.redis.port", () -> ((GenericContainer)redis).getFirstMappedPort());
    }

    static List<String> getKeys(String id) {
        String prefix = "redis-rate-limiter-lua-script-tests.{" + id;
        String tokens = prefix + "}.tokens";
        String timestamp = prefix + "}.timestamp";
        return Arrays.asList(tokens, timestamp);
    }

    static List<String> getArgs(long rate, long capacity, long now, long requested) {
        return Arrays.asList("" + rate, "" + capacity, "" + now, "" + requested);
    }

    @Test
    public void testNewAccess() {
        long rate = 1L;
        long capacity = 10L;
        long now = System.currentTimeMillis();
        long requested = 1L;
        List<String> keys = RedisRateLimiterLuaScriptTests.getKeys("new_access");
        List<String> args = RedisRateLimiterLuaScriptTests.getArgs(rate, capacity, now, requested);
        List result = (List)this.redisTemplate.execute(this.redisScript, keys, args).blockFirst();
        Assertions.assertThat((Long)((Long)result.get(0))).isEqualTo(1L);
        Assertions.assertThat((Long)((Long)result.get(1))).isEqualTo(9L);
        for (String key : keys) {
            long ttl = (Long)this.redisTemplate.getExpire((Object)key).map(duration -> duration.getSeconds()).block();
            long fillTime = capacity / rate;
            Assertions.assertThat((long)ttl).isGreaterThanOrEqualTo(fillTime);
        }
    }

    @Test
    public void testTokenFilled() {
        long rate = 1L;
        long capacity = 10L;
        long now = System.currentTimeMillis();
        long requested = 5L;
        List<String> keys = RedisRateLimiterLuaScriptTests.getKeys("token_filled");
        List<String> args = RedisRateLimiterLuaScriptTests.getArgs(rate, capacity, now, requested);
        this.redisTemplate.execute(this.redisScript, keys, args).blockFirst();
        args = RedisRateLimiterLuaScriptTests.getArgs(rate, capacity, now += 3L, requested);
        List result = (List)this.redisTemplate.execute(this.redisScript, keys, args).blockFirst();
        Assertions.assertThat((Long)((Long)result.get(0))).isEqualTo(1L);
        Assertions.assertThat((Long)((Long)result.get(1))).isEqualTo(3L);
        for (String key : keys) {
            long ttl = (Long)this.redisTemplate.getExpire((Object)key).map(duration -> duration.getSeconds()).block();
            long fillTime = capacity / rate;
            Assertions.assertThat((long)ttl).isGreaterThanOrEqualTo(fillTime);
        }
    }

    @Test
    public void testAfterTillTime() {
        long rate = 1L;
        long capacity = 10L;
        long now = System.currentTimeMillis();
        long requested = 1L;
        List<String> keys = RedisRateLimiterLuaScriptTests.getKeys("after_fill_time");
        List<String> args = RedisRateLimiterLuaScriptTests.getArgs(rate, capacity, now, requested);
        this.redisTemplate.execute(this.redisScript, keys, args).blockFirst();
        long fillTime = capacity / rate;
        args = RedisRateLimiterLuaScriptTests.getArgs(rate, capacity, now += fillTime, requested);
        List result = (List)this.redisTemplate.execute(this.redisScript, keys, args).blockFirst();
        Assertions.assertThat((Long)((Long)result.get(0))).isEqualTo(1L);
        Assertions.assertThat((Long)((Long)result.get(1))).isEqualTo(9L);
    }

    @Test
    public void testTokensNotEnough() {
        long rate = 1L;
        long capacity = 10L;
        long now = System.currentTimeMillis();
        long requested = 20L;
        List<String> keys = RedisRateLimiterLuaScriptTests.getKeys("tokens_not_enough");
        List<String> args = RedisRateLimiterLuaScriptTests.getArgs(rate, capacity, now, requested);
        List result = (List)this.redisTemplate.execute(this.redisScript, keys, args).blockFirst();
        Assertions.assertThat((Long)((Long)result.get(0))).isEqualTo(0L);
        Assertions.assertThat((Long)((Long)result.get(1))).isEqualTo(10L);
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    public static class TestConfig {
    }
}

