/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler;

import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.util.TestSocketUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"management.server.port=${test.port}"})
@DirtiesContext
public class RoutePredicateHandlerMappingIntegrationTests
extends BaseWebClientTests {
    private static int managementPort;

    @BeforeAll
    public static void beforeClass() {
        managementPort = TestSocketUtils.findAvailableTcpPort();
        System.setProperty("test.port", String.valueOf(managementPort));
    }

    @AfterAll
    public static void afterClass() {
        System.clearProperty("test.port");
    }

    @Test
    public void requestsToManagementPortReturn404() {
        String baseUrl = "http://localhost:" + managementPort;
        this.testClient.mutate().uriBuilderFactory((UriBuilderFactory)new DefaultUriBuilderFactory(baseUrl)).baseUrl(baseUrl).build().get().uri("/get", new Object[0]).exchange().expectStatus().isNotFound();
    }

    @Test
    public void requestsToManagementPortAndHostHeaderReturn404() {
        String host = "example.com:8888";
        String baseUrl = "http://localhost:" + managementPort;
        this.testClient.mutate().uriBuilderFactory((UriBuilderFactory)new DefaultUriBuilderFactory(baseUrl)).baseUrl(baseUrl).build().get().uri("/get", new Object[0]).header("host", new String[]{host}).exchange().expectStatus().isNotFound();
    }

    @Test
    public void andNotWorksWithMissingParameter() {
        this.testClient.get().uri("/andnotquery", new Object[0]).exchange().expectBody(String.class).isEqualTo((Object)"notsupplied");
    }

    @Test
    public void andNotWorksWithParameter() {
        this.testClient.get().uri("/andnotquery?myquery=shouldnotsee", new Object[0]).exchange().expectBody(String.class).isEqualTo((Object)"hasquery");
    }

    @Test
    public void andNestedOrQuery1() {
        this.testClient.get().uri("/andnestedquery?query1=hasquery1", new Object[0]).exchange().expectBody(String.class).isEqualTo((Object)"hasquery1,notsupplied");
    }

    @Test
    public void andNestedOrQuery2() {
        this.testClient.get().uri("/andnestedquery?query2=hasquery2", new Object[0]).exchange().expectBody(String.class).isEqualTo((Object)"notsupplied,hasquery2");
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    @RestController
    public static class TestConfig {
        @Value(value="${test.uri:http://httpbin.org:80}")
        String uri;

        @GetMapping(value={"/httpbin/andnotquery"})
        String andnotquery(@RequestParam(name="myquery", defaultValue="notsupplied") String myquery) {
            return myquery;
        }

        @GetMapping(value={"/httpbin/andnestedquery"})
        String andnotquery(@RequestParam(name="query1", defaultValue="notsupplied") String query1, @RequestParam(name="query2", defaultValue="notsupplied") String query2) {
            return query1 + "," + query2;
        }

        @GetMapping(value={"/httpbin/hasquery"})
        String hasquery() {
            return "hasquery";
        }

        @Bean
        RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("and_not_missing_myquery", r -> r.path(new String[]{"/andnotquery"}).and().not(p -> p.query("myquery")).filters(f -> f.prefixPath("/httpbin")).uri(this.uri)).route("and_not_has_myquery", r -> r.path(new String[]{"/andnotquery"}).and().query("myquery").filters(f -> f.setPath("/httpbin/hasquery")).uri(this.uri)).route("and_nested_query1_or_query2", r -> r.path(new String[]{"/andnestedquery"}).and().nested(p -> p.query("query1").or().query("query2")).filters(f -> f.prefixPath("/httpbin")).uri(this.uri)).build();
        }
    }
}

