/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.handler.predicate.CookieRoutePredicateFactory;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.http.HttpCookie;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;

public class CookieRoutePredicateFactoryTests
extends BaseWebClientTests {
    @Test
    public void noCookiesForYou() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"https://example.com", (Object[])new Object[0]).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        Predicate predicate = new CookieRoutePredicateFactory().apply(new CookieRoutePredicateFactory.Config().setName("mycookie").setRegexp("ch.p"));
        Assertions.assertThat((boolean)predicate.test(exchange)).isFalse();
    }

    @Test
    public void okOneCookieForYou() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"https://example.com", (Object[])new Object[0]).cookie(new HttpCookie[]{new HttpCookie("yourcookie", "sugar"), new HttpCookie("mycookie", "chip")}).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        Predicate predicate = new CookieRoutePredicateFactory().apply(new CookieRoutePredicateFactory.Config().setName("mycookie").setRegexp("ch.p"));
        Assertions.assertThat((boolean)predicate.test(exchange)).isTrue();
    }

    @Test
    public void toStringFormat() {
        CookieRoutePredicateFactory.Config config = new CookieRoutePredicateFactory.Config();
        config.setName("mycookie");
        config.setRegexp("myregexp");
        Predicate predicate = new CookieRoutePredicateFactory().apply(config);
        Assertions.assertThat((String)predicate.toString()).contains(new CharSequence[]{"Cookie: name=mycookie regexp=myregexp"});
    }

    @Test
    public void testConfig() {
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            Validator validator = factory.getValidator();
            CookieRoutePredicateFactory.Config config = new CookieRoutePredicateFactory.Config();
            config.setName("mycookie");
            config.setRegexp("myregexp");
            Assertions.assertThat((boolean)validator.validate((Object)config, new Class[0]).isEmpty()).isTrue();
        }
    }

    @Test
    public void testConfigNullField() {
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            Validator validator = factory.getValidator();
            CookieRoutePredicateFactory.Config config = new CookieRoutePredicateFactory.Config();
            Set validate = validator.validate((Object)config, new Class[0]);
            Assertions.assertThat((boolean)validate.isEmpty()).isFalse();
            Assertions.assertThat((int)validate.size()).isEqualTo(2);
        }
    }
}

