/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.handler.RoutePredicateHandlerMapping;
import org.springframework.cloud.gateway.handler.predicate.HeaderRoutePredicateFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class HeaderRoutePredicateFactoryTests
extends BaseWebClientTests {
    @Test
    public void headerRouteWorks() {
        this.testClient.get().uri("/get", new Object[0]).header("Foo", new String[]{"bar"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-Handler-Mapper-Class", new String[]{RoutePredicateHandlerMapping.class.getSimpleName()}).expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"header_test"});
    }

    @Test
    public void headerRouteIgnoredWhenHeaderMissing() {
        this.testClient.get().uri("/get", new Object[0]).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-Handler-Mapper-Class", new String[]{RoutePredicateHandlerMapping.class.getSimpleName()}).expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"default_path_to_httpbin"});
    }

    @Test
    public void headerExistsWorksWithDsl() {
        this.testClient.get().uri("/get", new Object[0]).header("X-Foo", new String[]{"bar"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-Handler-Mapper-Class", new String[]{RoutePredicateHandlerMapping.class.getSimpleName()}).expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"header_exists_dsl"});
    }

    @Test
    public void toStringFormat() {
        HeaderRoutePredicateFactory.Config config = new HeaderRoutePredicateFactory.Config();
        config.setHeader("myheader");
        config.setRegexp("myregexp");
        Predicate predicate = new HeaderRoutePredicateFactory().apply(config);
        Assertions.assertThat((String)predicate.toString()).contains(new CharSequence[]{"Header: myheader regexp=myregexp"});
    }

    @Test
    public void headerRouteHandlesCommaSeparatedValues() {
        this.testClient.get().uri("/get", new Object[0]).header("X-Example-Header", new String[]{"value1, value2 ,exact_match,value3"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-Handler-Mapper-Class", new String[]{RoutePredicateHandlerMapping.class.getSimpleName()}).expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"header_test_comma_separated"});
    }

    @Test
    public void testConfig() {
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            Validator validator = factory.getValidator();
            HeaderRoutePredicateFactory.Config config = new HeaderRoutePredicateFactory.Config();
            config.setHeader("myheader");
            Assertions.assertThat((boolean)validator.validate((Object)config, new Class[0]).isEmpty()).isTrue();
        }
    }

    @Test
    public void testConfigNullField() {
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            Validator validator = factory.getValidator();
            HeaderRoutePredicateFactory.Config config = new HeaderRoutePredicateFactory.Config();
            Set validate = validator.validate((Object)config, new Class[0]);
            Assertions.assertThat((boolean)validate.isEmpty()).isFalse();
            Assertions.assertThat((int)validate.size()).isEqualTo(1);
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        private String uri;

        @Bean
        RouteLocator queryRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("header_exists_dsl", r -> r.header("X-Foo").filters(f -> f.prefixPath("/httpbin")).uri(this.uri)).route("header_test_comma_separated", r -> r.header("X-Example-Header", "exact_match").filters(f -> f.prefixPath("/httpbin")).uri(this.uri)).build();
        }
    }
}

