/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.Arrays;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.handler.RoutePredicateHandlerMapping;
import org.springframework.cloud.gateway.handler.predicate.PathRoutePredicateFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.security.web.server.WebFilterChainProxy;
import org.springframework.security.web.server.firewall.ServerWebExchangeFirewall;
import org.springframework.security.web.server.firewall.StrictServerWebExchangeFirewall;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"debug=true"})
@DirtiesContext
public class PathRoutePredicateFactoryTests
extends BaseWebClientTests {
    @Test
    public void pathRouteWorks() {
        this.expectPathRoute("/abc/123/function", "www.path.org", "path_test");
    }

    @Test
    public void trailingSlashReturns404() {
        this.testClient.get().uri("/abc/123/function/", new Object[0]).header("Host", new String[]{"www.path.org"}).exchange().expectStatus().isNotFound();
    }

    @Test
    public void defaultPathRouteWorks() {
        this.expectPathRoute("/get", "www.thispathshouldnotmatch.org", "default_path_to_httpbin");
    }

    private void expectPathRoute(String uri, String host, String routeId) {
        this.testClient.get().uri(uri, new Object[0]).header("Host", new String[]{host}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-Handler-Mapper-Class", new String[]{RoutePredicateHandlerMapping.class.getSimpleName()}).expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{routeId});
    }

    @Test
    public void mulitPathRouteWorks() {
        this.expectPathRoute("/anything/multi11", "www.pathmulti.org", "path_multi");
        this.expectPathRoute("/anything/multi22", "www.pathmulti.org", "path_multi");
        this.expectPathRoute("/anything/multi33", "www.pathmulti.org", "default_path_to_httpbin");
    }

    @Test
    public void mulitPathDslRouteWorks() {
        this.expectPathRoute("/anything/multidsl1", "www.pathmultidsl.org", "path_multi_dsl");
        this.expectPathRoute("/anything/multidsl2", "www.pathmultidsl.org", "default_path_to_httpbin");
        this.expectPathRoute("/anything/multidsl3", "www.pathmultidsl.org", "path_multi_dsl");
    }

    @Test
    public void pathRouteWorksWithPercent() {
        this.testClient.get().uri("/abc/123%/function", new Object[0]).header("Host", new String[]{"www.path.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-Handler-Mapper-Class", new String[]{RoutePredicateHandlerMapping.class.getSimpleName()}).expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"path_test"});
    }

    @Test
    public void pathRouteWorksWithRegex() {
        this.testClient.get().uri("/regex/123", new Object[0]).header("Host", new String[]{"www.pathregex.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-Handler-Mapper-Class", new String[]{RoutePredicateHandlerMapping.class.getSimpleName()}).expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"path_regex"});
    }

    @Test
    public void matchOptionalTrailingSeparatorCopiedToMatchTrailingSlash() {
        PathRoutePredicateFactory.Config config = new PathRoutePredicateFactory.Config().setPatterns(Arrays.asList("patternA", "patternB")).setMatchTrailingSlash(false);
        Assertions.assertThat((boolean)config.isMatchTrailingSlash()).isEqualTo(false);
    }

    @Test
    public void toStringFormat() {
        PathRoutePredicateFactory.Config config = new PathRoutePredicateFactory.Config().setPatterns(Arrays.asList("patternA", "patternB")).setMatchTrailingSlash(false);
        Predicate predicate = new PathRoutePredicateFactory().apply(config);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)predicate.toString()).contains(new CharSequence[]{"patternA"})).contains(new CharSequence[]{"patternB"})).contains(new CharSequence[]{"false"});
    }

    @Test
    public void toStringFormatMatchTrailingSlashTrue() {
        PathRoutePredicateFactory.Config config = new PathRoutePredicateFactory.Config().setPatterns(Arrays.asList("patternA", "patternB")).setMatchTrailingSlash(true);
        Predicate predicate = new PathRoutePredicateFactory().apply(config);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)predicate.toString()).contains(new CharSequence[]{"patternA"})).contains(new CharSequence[]{"patternB"})).contains(new CharSequence[]{"true"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public BeanPostProcessor firewallPostProcessor() {
            return new BeanPostProcessor(){

                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    if (bean instanceof WebFilterChainProxy) {
                        WebFilterChainProxy webFilterChainProxy = (WebFilterChainProxy)bean;
                        StrictServerWebExchangeFirewall firewall = new StrictServerWebExchangeFirewall();
                        firewall.setAllowUrlEncodedPercent(true);
                        webFilterChainProxy.setFirewall((ServerWebExchangeFirewall)firewall);
                    }
                    return bean;
                }
            };
        }

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("path_multi_dsl", r -> r.host(new String[]{"**.pathmultidsl.org"}).and().path(false, new String[]{"/anything/multidsl1", "/anything/multidsl3"}).filters(f -> f.prefixPath("/httpbin")).uri(this.uri)).build();
        }
    }
}

