/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import org.openjdk.jmh.Main;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.springframework.cloud.gateway.handler.predicate.PathRoutePredicateFactory;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

public class PathRoutePredicatePathContainerAttrBenchMarkTests {
    private static List<Predicate<ServerWebExchange>> predicates = new LinkedList<Predicate<ServerWebExchange>>();
    private static String PATH_PATTERN_PREFIX;
    private static final String HOST = "http://localhost:8080";
    private static final int ROUTES_NUM = 2000;

    @Benchmark
    @Threads(value=2)
    @Fork(value=2)
    @BenchmarkMode(value={Mode.All})
    @Warmup(iterations=1, time=3)
    @Measurement(iterations=10, time=1)
    public void testPathContainerAttr() {
        Random random = new Random();
        MockServerHttpRequest request = MockServerHttpRequest.get((String)(HOST + PATH_PATTERN_PREFIX + random.nextInt(2000)), (Object[])new Object[0]).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        for (Predicate<ServerWebExchange> predicate : predicates) {
            if (predicate.test((ServerWebExchange)exchange)) break;
        }
    }

    public static void main(String[] args) throws Exception {
        Main.main((String[])args);
    }

    static {
        Random random = new Random();
        String path1 = String.format("%1$20s", random.nextInt()).replace(' ', '0');
        String path2 = String.format("%1$10s", random.nextInt()).replace(' ', '0');
        PATH_PATTERN_PREFIX = String.format("/%s/%s/", path1, path2);
        for (int i = 0; i < 2000; ++i) {
            PathRoutePredicateFactory.Config config = new PathRoutePredicateFactory.Config().setPatterns(Collections.singletonList(PATH_PATTERN_PREFIX + i)).setMatchTrailingSlash(true);
            Predicate predicate = new PathRoutePredicateFactory().apply(config);
            predicates.add(predicate);
        }
    }
}

