/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.system.CapturedOutput;
import org.springframework.boot.test.system.OutputCaptureExtension;
import org.springframework.cloud.gateway.handler.predicate.QueryRoutePredicateFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
@ExtendWith(value={OutputCaptureExtension.class})
public class QueryRoutePredicateFactoryTests
extends BaseWebClientTests {
    @Test
    public void noQueryParamWorks(CapturedOutput output) {
        this.testClient.get().uri("/get", new Object[0]).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"default_path_to_httpbin"});
        Assertions.assertThat((CharSequence)output).doesNotContain(new CharSequence[]{"Error applying predicate for route: foo_query_param"});
    }

    @Test
    public void queryParamWorks() {
        this.testClient.get().uri("/get?foo=bar", new Object[0]).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"foo_query_param"});
    }

    @Test
    public void emptyQueryParamWorks(CapturedOutput output) {
        this.testClient.get().uri("/get?foo", new Object[0]).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"default_path_to_httpbin"});
        Assertions.assertThat((CharSequence)output).doesNotContain(new CharSequence[]{"Error applying predicate for route: foo_query_param"});
    }

    @Test
    public void toStringFormat() {
        QueryRoutePredicateFactory.Config config = new QueryRoutePredicateFactory.Config();
        config.setParam("myparam");
        config.setRegexp("myregexp");
        Predicate predicate = new QueryRoutePredicateFactory().apply(config);
        Assertions.assertThat((String)predicate.toString()).contains(new CharSequence[]{"Query: param=myparam regexp=myregexp"});
    }

    @Test
    public void testConfig() {
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            Validator validator = factory.getValidator();
            QueryRoutePredicateFactory.Config config = new QueryRoutePredicateFactory.Config();
            config.setParam("myparam");
            Assertions.assertThat((boolean)validator.validate((Object)config, new Class[0]).isEmpty()).isTrue();
        }
    }

    @Test
    public void testConfigNullField() {
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            Validator validator = factory.getValidator();
            QueryRoutePredicateFactory.Config config = new QueryRoutePredicateFactory.Config();
            Set validate = validator.validate((Object)config, new Class[0]);
            Assertions.assertThat((boolean)validate.isEmpty()).isFalse();
            Assertions.assertThat((int)validate.size()).isEqualTo(1);
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        private String uri;

        @Bean
        RouteLocator queryRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("foo_query_param", r -> r.query("foo", "bar").filters(f -> f.prefixPath("/httpbin")).uri(this.uri)).build();
        }
    }
}

