/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.test;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.gateway.discovery.DiscoveryClientRouteDefinitionLocator;
import org.springframework.cloud.gateway.discovery.DiscoveryLocatorProperties;
import org.springframework.cloud.gateway.test.PermitAllSecurityConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

@SpringBootConfiguration
@EnableAutoConfiguration
@Import(value={PermitAllSecurityConfiguration.class})
public class GatewayTestApplication {
    public static void main(String[] args) {
        SpringApplication.run(GatewayTestApplication.class, (String[])args);
    }

    @Configuration(proxyBeanMethods=false)
    @EnableDiscoveryClient
    @Profile(value={"discovery"})
    protected static class GatewayDiscoveryConfiguration {
        protected GatewayDiscoveryConfiguration() {
        }

        @Bean
        public DiscoveryClientRouteDefinitionLocator discoveryClientRouteLocator(ReactiveDiscoveryClient discoveryClient, DiscoveryLocatorProperties properties) {
            return new DiscoveryClientRouteDefinitionLocator(discoveryClient, properties);
        }
    }
}

