/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.Objects;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSourceType;

public final class NamedSecretNormalizedSource
extends NormalizedSource {
    private final ConfigUtils.Prefix prefix;
    private final boolean includeProfileSpecificSources;
    private final boolean appendProfileToName;

    public NamedSecretNormalizedSource(String name, String namespace, boolean failFast, ConfigUtils.Prefix prefix, boolean includeProfileSpecificSources, boolean appendProfileToName) {
        super(name, namespace, failFast);
        this.prefix = Objects.requireNonNull(prefix);
        this.includeProfileSpecificSources = includeProfileSpecificSources;
        this.appendProfileToName = appendProfileToName;
    }

    public NamedSecretNormalizedSource(String name, String namespace, boolean failFast, boolean includeProfileSpecificSources) {
        this(name, namespace, failFast, ConfigUtils.Prefix.DEFAULT, includeProfileSpecificSources, false);
    }

    public NamedSecretNormalizedSource(String name, String namespace, boolean failFast, ConfigUtils.Prefix prefix, boolean includeProfileSpecificSources) {
        this(name, namespace, failFast, prefix, includeProfileSpecificSources, false);
    }

    public boolean profileSpecificSources() {
        return this.includeProfileSpecificSources;
    }

    public boolean appendProfileToName() {
        return this.appendProfileToName;
    }

    public ConfigUtils.Prefix prefix() {
        return this.prefix;
    }

    @Override
    public NormalizedSourceType type() {
        return NormalizedSourceType.NAMED_SECRET;
    }

    @Override
    public String target() {
        return "secret";
    }

    @Override
    public String toString() {
        return "{ secret name : '" + this.name() + "', namespace : '" + this.namespace() + "'";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedSecretNormalizedSource other = (NamedSecretNormalizedSource)o;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.namespace(), other.namespace());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name(), this.namespace());
    }
}

