/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.SelectedInstanceCallback;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Flux;

public class SameInstancePreferenceServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier
implements SelectedInstanceCallback {
    private static final Log LOG = LogFactory.getLog(SameInstancePreferenceServiceInstanceListSupplier.class);
    private ServiceInstance previouslyReturnedInstance;

    public SameInstancePreferenceServiceInstanceListSupplier(ServiceInstanceListSupplier delegate) {
        super(delegate);
    }

    @Override
    public String getServiceId() {
        return this.delegate.getServiceId();
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        return ((Flux)this.delegate.get()).map(this::filteredBySameInstancePreference);
    }

    private List<ServiceInstance> filteredBySameInstancePreference(List<ServiceInstance> serviceInstances) {
        if (this.previouslyReturnedInstance != null && serviceInstances.contains(this.previouslyReturnedInstance)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Returning previously selected service instance: %s", this.previouslyReturnedInstance));
            }
            return Collections.singletonList(this.previouslyReturnedInstance);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Previously selected service instance %s was not available. Returning all the instances returned by delegate.", this.previouslyReturnedInstance));
        }
        this.previouslyReturnedInstance = null;
        return serviceInstances;
    }

    @Override
    public void selectedServiceInstance(ServiceInstance serviceInstance) {
        if (this.previouslyReturnedInstance == null || !this.previouslyReturnedInstance.equals(serviceInstance)) {
            this.previouslyReturnedInstance = serviceInstance;
        }
    }
}

