/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor.sample;

import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.http.HttpMethod;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class RequestSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestSender.class);
    final WebClient webClient;
    final Tracer tracer;
    int port;
    Span span;

    RequestSender(WebClient webClient, Tracer tracer) {
        this.webClient = webClient;
        this.tracer = tracer;
    }

    public Mono<String> get(Integer someParameterNotUsedNow) {
        LOGGER.info("getting for parameter {}", (Object)someParameterNotUsedNow);
        this.span = this.tracer.currentSpan();
        return ((WebClient.RequestBodySpec)this.webClient.method(HttpMethod.GET).uri("http://localhost:" + this.port + "/foo", new Object[0])).retrieve().bodyToMono(String.class);
    }

    public Flux<String> getAll() {
        LOGGER.info("Before merge");
        Flux merge = Flux.merge((Publisher[])new Publisher[]{this.get(1), this.get(2), this.get(3)});
        LOGGER.info("after merge");
        return merge;
    }
}

