/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.zipkin2;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQAutoConfiguration;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.test.context.FilteredClassLoader;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin2.Call;
import zipkin2.CheckResult;
import zipkin2.Span;
import zipkin2.codec.Encoding;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.InMemoryReporterMetrics;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.Sender;
import zipkin2.reporter.activemq.ActiveMQSender;
import zipkin2.reporter.amqp.RabbitMQSender;
import zipkin2.reporter.kafka.KafkaSender;
import zipkin2.reporter.metrics.micrometer.MicrometerReporterMetrics;

public abstract class ZipkinAutoConfigurationTests {
    private final ApplicationContextRunner contextRunner = (ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{ZipkinAutoConfiguration.class, this.tracerZipkinConfiguration()}));
    public MockWebServer server = new MockWebServer();
    ExecutorService zipkinExecutor = Executors.newSingleThreadExecutor();

    protected abstract Class tracerZipkinConfiguration();

    protected abstract Class tracerConfiguration();

    @BeforeEach
    void setup() throws IOException {
        this.server.start();
    }

    @AfterEach
    void clean() throws IOException {
        this.server.close();
        this.zipkinExecutor.shutdown();
    }

    @Test
    void should_apply_micrometer_reporter_metrics_when_meter_registry_bean_present() {
        ((ApplicationContextRunner)this.contextRunner.withUserConfiguration(new Class[]{WithMeterRegistry.class})).run(context -> {
            ReporterMetrics bean = (ReporterMetrics)context.getBean(ReporterMetrics.class);
            BDDAssertions.then((Object)bean).isInstanceOf(MicrometerReporterMetrics.class);
        });
    }

    @Test
    void should_apply_in_memory_metrics_when_meter_registry_bean_missing() {
        this.contextRunner.run(context -> {
            ReporterMetrics bean = (ReporterMetrics)context.getBean(ReporterMetrics.class);
            BDDAssertions.then((Object)bean).isInstanceOf(InMemoryReporterMetrics.class);
        });
    }

    @Test
    void should_apply_in_memory_metrics_when_meter_registry_class_missing() {
        ((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)new FilteredClassLoader(new Class[]{MeterRegistry.class}))).run(context -> {
            ReporterMetrics bean = (ReporterMetrics)context.getBean(ReporterMetrics.class);
            BDDAssertions.then((Object)bean).isInstanceOf(InMemoryReporterMetrics.class);
        });
    }

    @Test
    void defaultsToV2Endpoint() throws Exception {
        ((ApplicationContextRunner)this.zipkinRunner().withPropertyValues(new String[]{"spring.zipkin.base-url=" + this.server.url("/").toString()})).run(context -> {
            ((Tracer)context.getBean(Tracer.class)).nextSpan().name("foo").tag("foo", "bar").start().end();
            ((AsyncReporter)context.getBean("zipkinReporter", AsyncReporter.class)).flush();
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((int)this.server.getRequestCount()).isGreaterThan(1));
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
                RecordedRequest request = this.server.takeRequest(1L, TimeUnit.SECONDS);
                BDDAssertions.then((Object)request).isNotNull();
                BDDAssertions.then((String)request.getPath()).isEqualTo("/api/v2/spans");
                BDDAssertions.then((String)request.getBody().readUtf8()).contains(new CharSequence[]{"localEndpoint"});
            });
        });
    }

    protected ApplicationContextRunner zipkinRunner() {
        return (ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{ZipkinAutoConfiguration.class, this.tracerZipkinConfiguration(), PropertyPlaceholderAutoConfiguration.class, this.tracerConfiguration(), KafkaAutoConfiguration.class, RabbitAutoConfiguration.class, ActiveMQAutoConfiguration.class}))).withUserConfiguration(new Class[]{this.configurationClass()});
    }

    protected abstract Class configurationClass();

    @Test
    public void encoderDirectsEndpoint() throws Exception {
        ((ApplicationContextRunner)this.zipkinRunner().withPropertyValues(new String[]{"spring.zipkin.base-url=" + this.server.url("/").toString(), "spring.zipkin.encoder=JSON_V1"})).run(context -> {
            ((Tracer)context.getBean(Tracer.class)).nextSpan().name("foo").tag("foo", "bar").start().end();
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((int)this.server.getRequestCount()).isGreaterThan(0));
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
                RecordedRequest request = this.server.takeRequest(1L, TimeUnit.SECONDS);
                BDDAssertions.then((Object)request).isNotNull();
                BDDAssertions.then((String)request.getPath()).isEqualTo("/api/v1/spans");
                BDDAssertions.then((String)request.getBody().readUtf8()).contains(new CharSequence[]{"binaryAnnotations"});
            });
        });
    }

    @Test
    public void overrideRabbitMQQueue() throws Exception {
        ((ApplicationContextRunner)this.zipkinRunner().withPropertyValues(new String[]{"spring.zipkin.rabbitmq.queue=zipkin2", "spring.zipkin.sender.type=rabbit"})).run(context -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)BDDAssertions.then((Object)context.getBean(Sender.class)).isInstanceOf(RabbitMQSender.class);
        });
    }

    @Test
    public void overrideKafkaTopic() throws Exception {
        ((ApplicationContextRunner)this.zipkinRunner().withPropertyValues(new String[]{"spring.zipkin.kafka.topic=zipkin2", "spring.zipkin.sender.type=kafka"})).run(context -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)BDDAssertions.then((Object)context.getBean(Sender.class)).isInstanceOf(KafkaSender.class);
        });
    }

    @Test
    public void overrideActiveMqQueue() throws Exception {
        ((ApplicationContextRunner)this.zipkinRunner().withPropertyValues(new String[]{"spring.jms.cache.enabled=false", "spring.zipkin.activemq.queue=zipkin2", "spring.zipkin.activemq.message-max-bytes=50", "spring.zipkin.sender.type=activemq"})).run(context -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)BDDAssertions.then((Object)context.getBean(Sender.class)).isInstanceOf(ActiveMQSender.class);
        });
    }

    @Test
    public void canOverrideBySender() throws Exception {
        ((ApplicationContextRunner)this.zipkinRunner().withPropertyValues(new String[]{"spring.zipkin.sender.type=web"})).run(context -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)BDDAssertions.then((String)((Sender)context.getBean(Sender.class)).getClass().getName()).contains(new CharSequence[]{"RestTemplateSender"});
        });
    }

    @Test
    public void canOverrideBySenderAndIsCaseInsensitive() throws Exception {
        ((ApplicationContextRunner)this.zipkinRunner().withPropertyValues(new String[]{"spring.zipkin.sender.type=WEB"})).run(context -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)BDDAssertions.then((String)((Sender)context.getBean(Sender.class)).getClass().getName()).contains(new CharSequence[]{"RestTemplateSender"});
        });
    }

    @Test
    public void rabbitWinsWhenKafkaPresent() throws Exception {
        ((ApplicationContextRunner)this.zipkinRunner().withPropertyValues(new String[]{"spring.zipkin.sender.type=rabbit"})).run(context -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)BDDAssertions.then((Object)context.getBean(Sender.class)).isInstanceOf(RabbitMQSender.class);
        });
    }

    @Test
    public void shouldOverrideDefaultBeans() {
        ((ApplicationContextRunner)((ApplicationContextRunner)this.zipkinRunner().withUserConfiguration(new Class[]{MyConfig.class})).withPropertyValues(new String[]{"spring.zipkin.sender.type=rabbit", "spring.zipkin.base-url=" + this.server.url("/").toString()})).run(context -> {
            BDDAssertions.then((Map)context.getBeansOfType(Sender.class)).hasSize(1);
            BDDAssertions.then((Map)context.getBeansOfType(Sender.class)).containsKeys((Object[])new String[]{"zipkinSender"});
            BDDAssertions.then((Map)context.getBeansOfType(Reporter.class)).hasSize(1);
            BDDAssertions.then((Map)context.getBeansOfType(Reporter.class)).containsKeys((Object[])new String[]{"zipkinReporter"});
            ((Tracer)context.getBean(Tracer.class)).nextSpan().name("foo").tag("foo", "bar").start().end();
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((int)this.server.getRequestCount()).isEqualTo(0));
            ((AsyncReporter)context.getBean("zipkinReporter", AsyncReporter.class)).flush();
            MyConfig.MySender sender = (MyConfig.MySender)((Object)((Object)context.getBean(MyConfig.MySender.class)));
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)sender.isSpanSent()).isTrue());
        });
    }

    @Test
    public void checkResult_onTime() {
        Sender sender = (Sender)Mockito.mock(Sender.class);
        Mockito.when((Object)sender.check()).thenReturn((Object)CheckResult.OK);
        Assertions.assertThat((boolean)ZipkinAutoConfiguration.checkResult((ExecutorService)this.zipkinExecutor, (Sender)sender, (long)200L).ok()).isTrue();
    }

    @Test
    public void checkResult_onTime_notOk() {
        Sender sender = (Sender)Mockito.mock(Sender.class);
        RuntimeException exception = new RuntimeException("dead");
        Mockito.when((Object)sender.check()).thenReturn((Object)CheckResult.failed((Throwable)exception));
        Assertions.assertThat((Throwable)ZipkinAutoConfiguration.checkResult((ExecutorService)this.zipkinExecutor, (Sender)sender, (long)200L).error()).isSameAs((Object)exception);
    }

    @Test
    public void checkResult_thrown() {
        Sender sender = (Sender)Mockito.mock(Sender.class);
        RuntimeException exception = new RuntimeException("dead");
        Mockito.when((Object)sender.check()).thenThrow(new Throwable[]{exception});
        Assertions.assertThat((Throwable)ZipkinAutoConfiguration.checkResult((ExecutorService)this.zipkinExecutor, (Sender)sender, (long)200L).error()).hasCause((Throwable)exception);
    }

    @Test
    public void checkResult_slow() {
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)ZipkinAutoConfiguration.checkResult((ExecutorService)this.zipkinExecutor, (Sender)new Sender(){

            public CheckResult check() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                return CheckResult.OK;
            }

            public Encoding encoding() {
                return Encoding.JSON;
            }

            public int messageMaxBytes() {
                return 0;
            }

            public int messageSizeInBytes(List<byte[]> list) {
                return 0;
            }

            public Call<Void> sendSpans(List<byte[]> list) {
                return Call.create(null);
            }

            public String toString() {
                return "FakeSender{}";
            }
        }, (long)200L).error()).isInstanceOf(TimeoutException.class)).hasMessage("Timed out after 200ms");
    }

    @Configuration(proxyBeanMethods=false)
    protected static class MyConfig {
        protected MyConfig() {
        }

        @Bean(value={"zipkinReporter"})
        Reporter<Span> myReporter(@Qualifier(value="zipkinSender") MySender mySender) {
            return AsyncReporter.create((Sender)mySender);
        }

        @Bean(value={"zipkinSender"})
        MySender mySender() {
            return new MySender();
        }

        static class MySender
        extends Sender {
            private boolean spanSent = false;

            MySender() {
            }

            boolean isSpanSent() {
                return this.spanSent;
            }

            public Encoding encoding() {
                return Encoding.JSON;
            }

            public int messageMaxBytes() {
                return Integer.MAX_VALUE;
            }

            public int messageSizeInBytes(List<byte[]> encodedSpans) {
                return this.encoding().listSizeInBytes(encodedSpans);
            }

            public Call<Void> sendSpans(List<byte[]> encodedSpans) {
                this.spanSent = true;
                return Call.create(null);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    protected static class MultipleReportersConfig {
        protected MultipleReportersConfig() {
        }

        @Bean
        Reporter<Span> otherReporter(OtherSender otherSender) {
            return AsyncReporter.create((Sender)otherSender);
        }

        @Bean
        OtherSender otherSender() {
            return new OtherSender();
        }

        static class OtherSender
        extends Sender {
            private boolean spanSent = false;

            OtherSender() {
            }

            boolean isSpanSent() {
                return this.spanSent;
            }

            public Encoding encoding() {
                return Encoding.JSON;
            }

            public int messageMaxBytes() {
                return Integer.MAX_VALUE;
            }

            public int messageSizeInBytes(List<byte[]> encodedSpans) {
                return this.encoding().listSizeInBytes(encodedSpans);
            }

            public Call<Void> sendSpans(List<byte[]> encodedSpans) {
                this.spanSent = true;
                return Call.create(null);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class WithReporter {
        WithReporter() {
        }

        @Bean
        Reporter<Span> spanReporter() {
            return Span::toString;
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class WithMeterRegistry {
        WithMeterRegistry() {
        }

        @Bean
        MeterRegistry meterRegistry() {
            return new SimpleMeterRegistry();
        }
    }
}

