/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.Tracing;
import brave.handler.MutableSpan;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpRequestParser;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.brave.bridge.BraveBaggageManager;
import org.springframework.cloud.sleuth.brave.bridge.BraveCurrentTraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveFinishedSpan;
import org.springframework.cloud.sleuth.brave.bridge.BraveHttpClientHandler;
import org.springframework.cloud.sleuth.brave.bridge.BraveHttpRequestParser;
import org.springframework.cloud.sleuth.brave.bridge.BraveHttpServerHandler;
import org.springframework.cloud.sleuth.brave.bridge.BravePropagator;
import org.springframework.cloud.sleuth.brave.bridge.BraveSpan;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveTracer;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.http.HttpServerHandler;
import org.springframework.cloud.sleuth.propagation.Propagator;

public final class BraveAccessor {
    private BraveAccessor() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static Tracer tracer(brave.Tracer braveTracer) {
        return new BraveTracer(braveTracer, new BraveBaggageManager());
    }

    public static CurrentTraceContext currentTraceContext(brave.propagation.CurrentTraceContext context) {
        return BraveCurrentTraceContext.fromBrave((brave.propagation.CurrentTraceContext)context);
    }

    public static TraceContext traceContext(brave.propagation.TraceContext traceContext) {
        return BraveTraceContext.fromBrave((brave.propagation.TraceContext)traceContext);
    }

    public static brave.propagation.TraceContext traceContext(TraceContext traceContext) {
        return BraveTraceContext.toBrave((TraceContext)traceContext);
    }

    public static brave.Span braveSpan(Span span) {
        return BraveSpan.toBrave((Span)span);
    }

    public static Propagator propagator(Tracing tracing) {
        return new BravePropagator(tracing);
    }

    public static HttpClientHandler httpClientHandler(brave.http.HttpClientHandler<HttpClientRequest, HttpClientResponse> delegate) {
        return new BraveHttpClientHandler(delegate);
    }

    public static HttpServerHandler httpServerHandler(brave.http.HttpServerHandler<HttpServerRequest, HttpServerResponse> delegate) {
        return new BraveHttpServerHandler(delegate);
    }

    public static HttpRequestParser httpRequestParser(org.springframework.cloud.sleuth.http.HttpRequestParser delegate) {
        return BraveHttpRequestParser.toBrave((org.springframework.cloud.sleuth.http.HttpRequestParser)delegate);
    }

    public static FinishedSpan finishedSpan(MutableSpan mutableSpan) {
        return new BraveFinishedSpan(mutableSpan);
    }
}

