/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.test;

import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.test.TestTracer;

class TestSpanBuilder
implements Span.Builder {
    private final Span.Builder delegate;
    private final TestTracer testTracer;

    TestSpanBuilder(Span.Builder delegate, TestTracer testTracer) {
        this.delegate = delegate;
        this.testTracer = testTracer;
    }

    public Span.Builder setParent(TraceContext context) {
        this.delegate.setParent(context);
        return this;
    }

    public Span.Builder setNoParent() {
        this.delegate.setNoParent();
        return this;
    }

    public Span.Builder name(String name) {
        this.delegate.name(name);
        return this;
    }

    public Span.Builder event(String value) {
        this.delegate.event(value);
        return this;
    }

    public Span.Builder tag(String key, String value) {
        this.delegate.tag(key, value);
        return this;
    }

    public Span.Builder error(Throwable throwable) {
        this.delegate.error(throwable);
        return this;
    }

    public Span.Builder kind(Span.Kind spanKind) {
        this.delegate.kind(spanKind);
        return this;
    }

    public Span.Builder remoteServiceName(String remoteServiceName) {
        this.delegate.remoteServiceName(remoteServiceName);
        return this;
    }

    public Span start() {
        Span span = this.delegate.start();
        this.testTracer.createdSpans.add(span);
        return span;
    }
}

