/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.square.okhttp.config;

import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.square.okhttp.core.OkHttpBuilderBeanPostProcessor;
import org.springframework.cloud.square.okhttp.core.OkHttpClientBuilderCustomizer;
import org.springframework.cloud.square.okhttp.loadbalancer.OkHttpLoadBalancerConfiguration;
import org.springframework.cloud.square.okhttp.tracing.OkHttpTracingConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={OkHttpClient.class})
@Import(value={OkHttpLoadBalancerConfiguration.class, OkHttpTracingConfiguration.class})
public class OkHttpAutoConfiguration {
    @Bean
    public OkHttpBuilderBeanPostProcessor okHttpBuilderBeanPostProcessor(ObjectProvider<OkHttpClientBuilderCustomizer> customizers, ApplicationContext context) {
        return new OkHttpBuilderBeanPostProcessor(customizers, context);
    }

    @Bean
    public OkHttpClientBuilderCustomizer okHttpClientBuilderCustomizer(List<Interceptor> interceptors) {
        return builder -> interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)builder).addInterceptor(arg_0));
    }
}

