/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.square.okhttp.loadbalancer;

import okhttp3.OkHttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.square.okhttp.loadbalancer.OkHttpLoadBalancerInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={OkHttpClient.class, LoadBalancerClient.class})
@ConditionalOnBean(value={LoadBalancerClient.class})
@ConditionalOnProperty(value={"spring.cloud.square.okhttp.loadbalancer.enabled"}, havingValue="true", matchIfMissing=true)
public class OkHttpLoadBalancerConfiguration {
    @Bean
    public OkHttpLoadBalancerInterceptor okHttpLoadBalancerInterceptor(LoadBalancerClient client) {
        return new OkHttpLoadBalancerInterceptor(client);
    }
}

