/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.square.okhttp.tracing;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.square.okhttp.tracing.TracingOkHttpInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={TraceContext.class})
@ConditionalOnBean(value={CurrentTraceContext.class, HttpClientHandler.class})
@ConditionalOnProperty(value={"spring.cloud.square.okhttp.tracing.enabled"}, havingValue="true", matchIfMissing=true)
public class OkHttpTracingConfiguration {
    @Bean
    public TracingOkHttpInterceptor tracingOkHttpInterceptor(CurrentTraceContext currentTraceContext, HttpClientHandler httpClientHandler) {
        return new TracingOkHttpInterceptor(currentTraceContext, httpClientHandler);
    }
}

