/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.square.okhttp.tracing;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.http.HttpClientRequest;
import org.springframework.cloud.sleuth.http.HttpClientResponse;
import org.springframework.lang.Nullable;

public class TracingOkHttpInterceptor
implements Interceptor {
    final CurrentTraceContext currentTraceContext;
    final HttpClientHandler httpClientHandler;

    public TracingOkHttpInterceptor(CurrentTraceContext currentTraceContext, HttpClientHandler httpClientHandler) {
        this.currentTraceContext = currentTraceContext;
        this.httpClientHandler = httpClientHandler;
    }

    private static void parseRouteAddress(Interceptor.Chain chain, Span span) {
        if (span.isNoop()) {
            return;
        }
        Connection connection = chain.connection();
        if (connection == null) {
            return;
        }
        InetSocketAddress socketAddress = connection.route().socketAddress();
        span.remoteIpAndPort(socketAddress.getHostString(), socketAddress.getPort());
    }

    /*
     * Exception decompiling
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static final class ResponseWrapper
    implements HttpClientResponse {
        final RequestWrapper request;
        @Nullable
        final Response response;
        @Nullable
        final Throwable error;

        ResponseWrapper(RequestWrapper request, @Nullable Response response, @Nullable Throwable error) {
            this.request = request;
            this.response = response;
            this.error = error;
        }

        public Object unwrap() {
            return this.response;
        }

        public Collection<String> headerNames() {
            return this.response != null ? this.response.headers().toMultimap().keySet() : Collections.emptyList();
        }

        public RequestWrapper request() {
            return this.request;
        }

        public Throwable error() {
            return this.error;
        }

        public int statusCode() {
            return this.response != null ? this.response.code() : 0;
        }
    }

    static final class RequestWrapper
    implements HttpClientRequest {
        final Request delegate;
        Request.Builder builder;

        RequestWrapper(Request delegate) {
            this.delegate = delegate;
        }

        public Collection<String> headerNames() {
            return this.delegate.headers().toMultimap().keySet();
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.method();
        }

        public String path() {
            return this.delegate.url().encodedPath();
        }

        public String url() {
            return this.delegate.url().toString();
        }

        public String header(String name) {
            return this.delegate.header(name);
        }

        public void header(String name, String value) {
            if (this.builder == null) {
                this.builder = this.delegate.newBuilder();
            }
            this.builder.header(name, value);
        }

        Request build() {
            return this.builder != null ? this.builder.build() : this.delegate;
        }
    }
}

