/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.springframework.cloud.internal.Logger;
import org.springframework.cloud.internal.Project;
import org.springframework.cloud.internal.ReleaseType;
import org.springframework.cloud.internal.ZipCategory;
import org.springframework.util.FileSystemUtils;

class ArtifactFetcher {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    private final File outputFolder;
    private final String repoUrl;

    ArtifactFetcher(File outputFolder, String repoUrl) {
        this.outputFolder = outputFolder;
        this.repoUrl = repoUrl;
    }

    File unpackedDocs(Project project) {
        String projectName = project.name;
        String version = project.version;
        List<String> urls = this.urls(projectName, version);
        File downloadedZipsFolder = new File(this.outputFolder, "downloaded-zips");
        downloadedZipsFolder.mkdirs();
        File outputZip = new File(downloadedZipsFolder, projectName + ".zip");
        for (String url : urls) {
            try {
                Logger.info(projectName + ": Fetching sources from [" + url + "]. Please wait...");
                FileUtils.copyURLToFile((URL)new URL(url), (File)outputZip, (int)5000, (int)5000);
                Logger.info(projectName + ": Successfully fetched a zip from [" + url + "] to [" + outputZip + "]");
                break;
            }
            catch (IOException ex) {
                Logger.error(projectName + ": Failed to fetch a zip from [" + url + "]");
            }
        }
        if (!outputZip.exists()) {
            Logger.error(projectName + ": Exception occurred while trying to download an artifact with name [" + projectName + "] and version [" + version + "]");
            return null;
        }
        return this.unpackDocs(projectName, outputZip);
    }

    private File unpackDocs(String projectName, File outputZip) {
        File unpackedDoc = this.unpackDoc(projectName, outputZip);
        Logger.info(projectName + ": Unpacked file to [" + unpackedDoc.getAbsolutePath() + "]");
        if (unpackedDoc.isDirectory()) {
            String[] subfolders = unpackedDoc.list();
            if (subfolders == null || subfolders.length != 1) {
                return unpackedDoc;
            }
            this.moveOneFolderUp(unpackedDoc, subfolders[0]);
        }
        return unpackedDoc;
    }

    private void moveOneFolderUp(File unpackedDoc, String subfolder) {
        File onlySubfolder = new File(unpackedDoc, subfolder);
        try {
            FileSystemUtils.copyRecursively((File)onlySubfolder, (File)unpackedDoc);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        FileSystemUtils.deleteRecursively((File)onlySubfolder);
    }

    private List<String> urls(String projectName, String version) {
        ReleaseType releaseType = ReleaseType.fromVersion(version);
        String sourcesUrl = this.repoUrl + projectName + "/archive/";
        LinkedList<String> sourcesUrls = new LinkedList<String>();
        if (releaseType == ReleaseType.SNAPSHOT) {
            String[] splitVersion = version.split("\\.");
            sourcesUrls.add(sourcesUrl + splitVersion[0] + "." + splitVersion[1] + ".x.zip");
            sourcesUrls.add(sourcesUrl + "main.zip");
            sourcesUrls.add(sourcesUrl + "master.zip");
        } else {
            sourcesUrls.add(sourcesUrl + "v" + version + ".zip");
            sourcesUrls.add(sourcesUrl + version + ".zip");
        }
        return sourcesUrls;
    }

    private File unpackDoc(String artifactName, File zip) {
        File unzippedDocs = new File(this.outputFolder, artifactName);
        unzippedDocs.mkdirs();
        Logger.info(artifactName + ": Unpacking from [" + zip + "]");
        ZipCategory.unzipTo(zip, unzippedDocs);
        return unzippedDocs;
    }
}

