/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.internal;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.internal.ConfigurationProperty;
import org.springframework.util.StringUtils;

class ConfigurationPropertiesAggregator {
    private static final List<String> wordsToIgnore = Arrays.asList("|===", "|Name | Default | Description");

    ConfigurationPropertiesAggregator() {
    }

    List<ConfigurationProperty> mergedConfigurationProperties(Path unpackedDocs) {
        try {
            return Files.walk(unpackedDocs, new FileVisitOption[0]).filter(path -> path.endsWith("_configprops.adoc")).flatMap(path -> {
                try {
                    return Files.readAllLines(path).stream().filter(s -> !StringUtils.isEmpty((Object)s) && !wordsToIgnore.contains(s)).map(s -> {
                        String[] strings = s.substring(1).split("\\|");
                        if (strings.length == 3) {
                            return new ConfigurationProperty(strings[0].trim(), strings[1].trim().replace("`", ""), strings[2].trim());
                        }
                        if (strings.length == 2) {
                            return new ConfigurationProperty(strings[0].trim(), strings[1].trim().replace("`", ""), "");
                        }
                        return new ConfigurationProperty(strings[0].trim(), "", "");
                    });
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }).sorted(Comparator.comparing(o -> o.name)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

