/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.internal;

import java.io.File;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;
import org.springframework.cloud.internal.Logger;
import org.springframework.cloud.internal.PomReader;
import org.springframework.cloud.internal.Project;
import org.springframework.cloud.internal.TemplateGenerator;

public class GenerateReleaseTrainDocs {
    public static void main(String ... args) {
        File bomPath = new File(args[0]);
        File starterParentPath = new File(args[1]);
        File generatedTrainDocs = new File(args[2]);
        new GenerateReleaseTrainDocs().generate(bomPath, starterParentPath, generatedTrainDocs);
    }

    void generate(File bomPath, File starterParentPath, File generatedTrainDocs) {
        List<Project> projects = this.mavenPropertiesToDocsProjects(bomPath);
        Logger.info("Found the following projects [" + projects + "]");
        projects.add(this.springBootVersion(starterParentPath));
        projects.sort(Comparator.comparing(o -> o.name));
        File file = this.renderAsciidocTemplates(generatedTrainDocs, projects);
        Logger.info("Rendered docs templates to [" + file + "]");
    }

    List<Project> mavenPropertiesToDocsProjects(File file) {
        Model model = PomReader.readPom(file);
        Properties properties = model.getProperties();
        return properties.entrySet().stream().filter(e -> e.getKey().toString().endsWith(".version")).map(e -> new Project(e.getKey().toString().replace(".version", ""), e.getValue().toString())).collect(Collectors.toCollection(LinkedList::new));
    }

    Project springBootVersion(File file) {
        Model model = PomReader.readPom(file);
        return new Project("spring-boot", model.getParent().getVersion());
    }

    File renderAsciidocTemplates(File generatedTrainDocs, List<Project> projects) {
        TemplateGenerator templateGenerator = new TemplateGenerator(generatedTrainDocs);
        return templateGenerator.generate(projects);
    }
}

