/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.internal;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

final class PomReader {
    private PomReader() {
        throw new IllegalStateException("Shouldn't instantiate a utility class");
    }

    public static Model readPom(File pom) {
        Model model;
        if (!pom.exists()) {
            throw new IllegalStateException("File [" + pom.getAbsolutePath() + "] not found");
        }
        String fileText = "";
        FileReader reader = new FileReader(pom);
        try {
            if (pom.isFile()) {
                fileText = new String(Files.readAllBytes(pom.toPath()));
            }
            MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
            model = xpp3Reader.read((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | XmlPullParserException e) {
                if (pom.isFile() && fileText.length() == 0) {
                    throw new IllegalStateException("File [" + pom.getAbsolutePath() + "] is empty", e);
                }
                throw new IllegalStateException("Failed to read file: " + pom.getAbsolutePath(), e);
            }
        }
        ((Reader)reader).close();
        return model;
    }
}

