/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.internal;

import com.github.jknack.handlebars.Template;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.internal.HandlebarsHelper;
import org.springframework.cloud.internal.Logger;
import org.springframework.cloud.internal.Project;
import org.springframework.cloud.internal.TemplateProject;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

class TemplateGenerator {
    final File outputFolder;

    TemplateGenerator(File outputFolder) {
        this.outputFolder = outputFolder;
        this.outputFolder.mkdirs();
    }

    File generate(List<Project> projects) {
        PathMatchingResourcePatternResolver resourceLoader = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resourceLoader.getResources("templates/spring-cloud/*.hbs");
            List<TemplateProject> templateProjects = this.templateProjects(projects);
            for (Resource resource : resources) {
                File templateFile = resource.getFile();
                File outputFile = new File(this.outputFolder, this.renameTemplate(templateFile));
                Template template = this.template(templateFile.getName().replace(".hbs", ""));
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("projects", projects);
                map.put("springBootVersion", projects.stream().filter(project -> project.name.equals("spring-boot")).findFirst().orElse(new Project("spring-boot", "")).getVersion());
                map.put("springCloudProjects", templateProjects);
                String applied = template.apply(map);
                Files.write(outputFile.toPath(), applied.getBytes(), new OpenOption[0]);
                Logger.info("Successfully rendered [" + outputFile.getAbsolutePath() + "]");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this.outputFolder;
    }

    private List<TemplateProject> templateProjects(List<Project> projects) {
        return projects.stream().filter(project -> project.name.startsWith("spring-cloud-")).map(project -> new TemplateProject(project.name, project.version, "{basedir}/" + project.name + "/docs/src/main/asciidoc/" + project.name + ".adoc[leveloffset=+1]")).collect(Collectors.toCollection(LinkedList::new));
    }

    private String renameTemplate(File templateFile) {
        String templateName = templateFile.getName();
        return templateName.replace(".hbs", ".adoc");
    }

    private Template template(String template) {
        return HandlebarsHelper.template(template);
    }
}

