/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.internal;

import java.util.Objects;

class TemplateProject {
    final String name;
    final String version;
    final String antoraVersion;
    final String include;

    TemplateProject(String name, String version, String include) {
        this.name = name;
        this.version = version;
        this.include = include;
        this.antoraVersion = this.toAntora(version);
    }

    private String toAntora(String version) {
        String[] split = version.split("\\.");
        boolean snapshot = version.contains("SNAPSHOT");
        String majorMinor = split[0] + "." + split[1];
        if (snapshot) {
            return majorMinor + "-SNAPSHOT";
        }
        return majorMinor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateProject that = (TemplateProject)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.antoraVersion, that.antoraVersion) && Objects.equals(this.include, that.include);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.antoraVersion, this.include);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getInclude() {
        return this.include;
    }

    public String getAntoraVersion() {
        return this.antoraVersion;
    }
}

