/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.metrics;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.boot.actuate.endpoint.MetricsEndpoint;
import org.springframework.boot.actuate.endpoint.MetricsEndpointMetricReader;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.export.Exporter;
import org.springframework.cloud.stream.metrics.ApplicationMetrics;
import org.springframework.cloud.stream.metrics.ApplicationMetricsProperties;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;

public class ApplicationMetricsExporter
implements Exporter {
    private MessageChannel source;
    private ApplicationMetricsProperties properties;
    private MetricsEndpointMetricReader metricsReader;

    public ApplicationMetricsExporter(MetricsEndpoint endpoint, MessageChannel source, ApplicationMetricsProperties properties) {
        this.source = source;
        this.properties = properties;
        this.metricsReader = new MetricsEndpointMetricReader(endpoint);
    }

    public void export() {
        ApplicationMetrics appMetrics = new ApplicationMetrics(this.properties.getMetricName(), this.filter());
        appMetrics.setProperties(this.properties.getExportProperties());
        this.source.send(MessageBuilder.withPayload((Object)appMetrics).build());
    }

    protected Collection<Metric<?>> filter() {
        ArrayList result = new ArrayList();
        Iterable metrics = this.metricsReader.findAll();
        for (Metric metric : metrics) {
            if (!this.isMatch(metric.getName(), this.properties.getTrigger().getIncludes(), this.properties.getTrigger().getExcludes())) continue;
            result.add(metric);
        }
        return result;
    }

    private boolean isMatch(String name, String[] includes, String[] excludes) {
        if (ObjectUtils.isEmpty((Object[])includes) || PatternMatchUtils.simpleMatch((String[])includes, (String)name)) {
            return !PatternMatchUtils.simpleMatch((String[])excludes, (String)name);
        }
        return false;
    }
}

