/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.avro;

import java.io.IOException;
import java.util.Collection;
import org.apache.avro.Schema;
import org.springframework.cloud.stream.schema.avro.AbstractAvroMessageConverter;
import org.springframework.core.io.Resource;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public class AvroSchemaMessageConverter
extends AbstractAvroMessageConverter {
    private Schema schema;

    public AvroSchemaMessageConverter() {
        super(new MimeType("application", "avro"));
    }

    public AvroSchemaMessageConverter(MimeType supportedMimeType) {
        super(supportedMimeType);
    }

    public AvroSchemaMessageConverter(Collection<MimeType> supportedMimeTypes) {
        super(supportedMimeTypes);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        Assert.notNull((Object)schema, (String)"schema cannot be null");
        this.schema = schema;
    }

    public void setSchemaLocation(Resource schemaLocation) {
        Assert.notNull((Object)schemaLocation, (String)"schema cannot be null");
        try {
            this.schema = AvroSchemaMessageConverter.parseSchema(schemaLocation);
        }
        catch (IOException e) {
            throw new IllegalStateException("Schema cannot be parsed:", e);
        }
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    protected Schema resolveWriterSchemaForDeserialization(MimeType mimeType) {
        return this.schema;
    }

    @Override
    protected Schema resolveReaderSchemaForDeserialization(Class<?> targetClass) {
        return this.schema;
    }

    @Override
    protected Schema resolveSchemaForWriting(Object payload, MessageHeaders headers, MimeType hintedContentType) {
        return this.schema;
    }
}

