/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.springframework.cloud.stream.schema.SchemaReference;
import org.springframework.cloud.stream.schema.SchemaRegistrationResponse;
import org.springframework.cloud.stream.schema.client.SchemaRegistryClient;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ConfluentSchemaRegistryClient
implements SchemaRegistryClient {
    private RestTemplate template = new RestTemplate();
    private String endpoint = "http://localhost:8081";
    private ObjectMapper mapper = new ObjectMapper();

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public SchemaRegistrationResponse register(String subject, String format, String schema) {
        Assert.isTrue((boolean)"avro".equals(format), (String)"Only Avro is supported");
        String path = String.format("/subjects/%s/versions", subject);
        HttpHeaders headers = new HttpHeaders();
        headers.put("Accept", Arrays.asList("application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json"));
        headers.add("Content-Type", "application/json");
        Integer id = null;
        try {
            String payload = this.mapper.writeValueAsString(Collections.singletonMap("schema", schema));
            HttpEntity request = new HttpEntity((Object)payload, (MultiValueMap)headers);
            ResponseEntity response = this.template.exchange(this.endpoint + path, HttpMethod.POST, request, Map.class, new Object[0]);
            id = (Integer)((Map)response.getBody()).get("id");
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        SchemaRegistrationResponse schemaRegistrationResponse = new SchemaRegistrationResponse();
        schemaRegistrationResponse.setId(id);
        schemaRegistrationResponse.setSchemaReference(new SchemaReference(subject, id, "avro"));
        return schemaRegistrationResponse;
    }

    @Override
    public String fetch(SchemaReference schemaReference) {
        String path = String.format("/schemas/ids/%d", schemaReference.getVersion());
        HttpHeaders headers = new HttpHeaders();
        headers.put("Accept", Arrays.asList("application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json"));
        headers.add("Content-Type", "application/vnd.schemaregistry.v1+json");
        HttpEntity request = new HttpEntity((Object)"", (MultiValueMap)headers);
        ResponseEntity response = this.template.exchange(this.endpoint + path, HttpMethod.GET, request, Map.class, new Object[0]);
        return (String)((Map)response.getBody()).get("schema");
    }

    @Override
    public String fetch(int id) {
        String path = String.format("/schemas/ids/%d", id);
        HttpHeaders headers = new HttpHeaders();
        headers.put("Accept", Arrays.asList("application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json"));
        headers.add("Content-Type", "application/vnd.schemaregistry.v1+json");
        HttpEntity request = new HttpEntity((Object)"", (MultiValueMap)headers);
        ResponseEntity response = this.template.exchange(this.endpoint + path, HttpMethod.GET, request, Map.class, new Object[0]);
        return (String)((Map)response.getBody()).get("schema");
    }
}

