/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema;

import org.springframework.util.Assert;

public class SchemaReference {
    private String subject;
    private int version;
    private String format;

    public SchemaReference(String subject, int version, String format) {
        Assert.hasText((String)subject, (String)"cannot be empty");
        Assert.isTrue((version > 0 ? 1 : 0) != 0, (String)"must be a positive integer");
        Assert.hasText((String)format, (String)"cannot be empty");
        this.subject = subject;
        this.version = version;
        this.format = format;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        Assert.hasText((String)subject, (String)"cannot be empty");
        this.subject = subject;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        Assert.isTrue((version > 0 ? 1 : 0) != 0, (String)"must be a positive integer");
        this.version = version;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        Assert.hasText((String)format, (String)"cannot be empty");
        this.format = format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaReference that = (SchemaReference)o;
        if (this.version != that.version) {
            return false;
        }
        if (!this.subject.equals(that.subject)) {
            return false;
        }
        return this.format.equals(that.format);
    }

    public int hashCode() {
        int result = this.subject.hashCode();
        result = 31 * result + this.version;
        result = 31 * result + this.format.hashCode();
        return result;
    }

    public String toString() {
        return "SchemaReference{subject='" + this.subject + '\'' + ", version=" + this.version + ", format='" + this.format + '\'' + '}';
    }
}

