/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.avro;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.cloud.stream.schema.avro.AvroMessageConverterProperties;
import org.springframework.cloud.stream.schema.avro.AvroSchemaRegistryClientMessageConverter;
import org.springframework.cloud.stream.schema.client.SchemaRegistryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ObjectUtils;

@Configuration
@ConditionalOnClass(name={"org.apache.avro.Schema"})
@ConditionalOnProperty(value={"spring.cloud.stream.schemaRegistryClient.enabled"}, matchIfMissing=true)
@ConditionalOnBean(type={"org.springframework.cloud.stream.schema.client.SchemaRegistryClient"})
@EnableConfigurationProperties(value={AvroMessageConverterProperties.class})
public class AvroMessageConverterAutoConfiguration {
    @Autowired
    private AvroMessageConverterProperties avroMessageConverterProperties;

    @Bean
    @ConditionalOnMissingBean(value={AvroSchemaRegistryClientMessageConverter.class})
    public AvroSchemaRegistryClientMessageConverter avroSchemaMessageConverter(SchemaRegistryClient schemaRegistryClient) {
        AvroSchemaRegistryClientMessageConverter avroSchemaRegistryClientMessageConverter = new AvroSchemaRegistryClientMessageConverter(schemaRegistryClient);
        avroSchemaRegistryClientMessageConverter.setDynamicSchemaGenerationEnabled(this.avroMessageConverterProperties.isDynamicSchemaGenerationEnabled());
        if (this.avroMessageConverterProperties.getReaderSchema() != null) {
            avroSchemaRegistryClientMessageConverter.setReaderSchema(this.avroMessageConverterProperties.getReaderSchema());
        }
        if (!ObjectUtils.isEmpty((Object[])this.avroMessageConverterProperties.getSchemaLocations())) {
            avroSchemaRegistryClientMessageConverter.setSchemaLocations(this.avroMessageConverterProperties.getSchemaLocations());
        }
        avroSchemaRegistryClientMessageConverter.setPrefix(this.avroMessageConverterProperties.getPrefix());
        avroSchemaRegistryClientMessageConverter.setCacheManager(this.cacheManager());
        return avroSchemaRegistryClientMessageConverter;
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheManager cacheManager() {
        return new ConcurrentMapCacheManager();
    }
}

