/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.client;

import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.stream.schema.SchemaReference;
import org.springframework.cloud.stream.schema.SchemaRegistrationResponse;
import org.springframework.cloud.stream.schema.client.SchemaRegistryClient;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class DefaultSchemaRegistryClient
implements SchemaRegistryClient {
    private RestTemplate template = new RestTemplate();
    private String endpoint = "http://localhost:8990";

    public void setEndpoint(String endpoint) {
        Assert.hasText((String)endpoint, (String)"cannot be empty");
        this.endpoint = endpoint;
    }

    @Override
    public SchemaRegistrationResponse register(String subject, String format, String schema) {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("subject", subject);
        requestBody.put("format", format);
        requestBody.put("definition", schema);
        ResponseEntity responseEntity = this.template.postForEntity(this.endpoint, requestBody, Map.class, new Object[0]);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            SchemaRegistrationResponse registrationResponse = new SchemaRegistrationResponse();
            Map responseBody = (Map)responseEntity.getBody();
            registrationResponse.setId((Integer)responseBody.get("id"));
            registrationResponse.setSchemaReference(new SchemaReference(subject, (Integer)responseBody.get("version"), responseBody.get("format").toString()));
            return registrationResponse;
        }
        throw new RuntimeException("Failed to register schema: " + responseEntity.toString());
    }

    @Override
    public String fetch(SchemaReference schemaReference) {
        ResponseEntity responseEntity = this.template.getForEntity(this.endpoint + "/" + schemaReference.getSubject() + "/" + schemaReference.getFormat() + "/v" + schemaReference.getVersion(), Map.class, new Object[0]);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            throw new RuntimeException("Failed to fetch schema: " + responseEntity.toString());
        }
        return (String)((Map)responseEntity.getBody()).get("definition");
    }

    @Override
    public String fetch(int id) {
        ResponseEntity responseEntity = this.template.getForEntity(this.endpoint + "/schemas/" + id, Map.class, new Object[0]);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            throw new RuntimeException("Failed to fetch schema: " + responseEntity.toString());
        }
        return (String)((Map)responseEntity.getBody()).get("definition");
    }
}

