/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.event.MappingContextEvent;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.MutablePersistentEntity;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingContext<E extends MutablePersistentEntity<?, P>, P extends PersistentProperty<P>>
implements MappingContext<E, P>,
InitializingBean,
ApplicationEventPublisherAware {
    private static final Set<String> UNMAPPED_FIELDS = new HashSet<String>(Arrays.asList("class", "this$0"));
    private ApplicationEventPublisher applicationEventPublisher;
    private ConcurrentMap<TypeInformation<?>, E> persistentEntities = new ConcurrentHashMap();
    private ConcurrentMap<E, List<Validator>> validators = new ConcurrentHashMap<E, List<Validator>>();
    private List<Class<?>> customSimpleTypes = new ArrayList();
    private Set<? extends Class<?>> initialEntitySet = new HashSet();
    private boolean strict = false;
    private SimpleTypeHolder simpleTypeHolder = new SimpleTypeHolder();

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setInitialEntitySet(Set<? extends Class<?>> initialEntitySet) {
        this.initialEntitySet = initialEntitySet;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setSimpleTypeHolder(SimpleTypeHolder simpleTypes) {
        this.simpleTypeHolder = simpleTypes == null ? new SimpleTypeHolder() : simpleTypes;
    }

    @Override
    public Collection<E> getPersistentEntities() {
        return this.persistentEntities.values();
    }

    @Override
    public E getPersistentEntity(Class<?> type) {
        return (E)this.getPersistentEntity((TypeInformation)ClassTypeInformation.from(type));
    }

    @Override
    public E getPersistentEntity(TypeInformation<?> type) {
        MutablePersistentEntity entity = (MutablePersistentEntity)this.persistentEntities.get(type);
        if (entity != null) {
            return (E)entity;
        }
        if (this.strict) {
            throw new MappingException("Unknown persistent entity " + type);
        }
        return this.addPersistentEntity(type);
    }

    @Override
    public <T> Iterable<P> getPersistentPropertyPath(Class<T> type, String path) {
        Iterator<String> parts = Arrays.asList(path.split("\\.")).iterator();
        ArrayList result = new ArrayList();
        PersistentEntity current = this.getPersistentEntity((Class)type);
        while (parts.hasNext()) {
            String name = parts.next();
            Object property = current.getPersistentProperty(name);
            if (property == null) {
                throw new IllegalArgumentException(String.format("No property %s found on %s!", name, current.getName()));
            }
            result.add(property);
            current = this.getPersistentEntity((TypeInformation)property.getTypeInformation().getActualType());
        }
        return result;
    }

    @Override
    public List<Validator> getEntityValidators(E entity) {
        return (List)this.validators.get(entity);
    }

    protected E addPersistentEntity(Class<?> type) {
        return this.addPersistentEntity(ClassTypeInformation.from(type));
    }

    protected E addPersistentEntity(TypeInformation<?> typeInformation) {
        MutablePersistentEntity persistentEntity = (MutablePersistentEntity)this.persistentEntities.get(typeInformation);
        if (persistentEntity != null) {
            return (E)persistentEntity;
        }
        Class<?> type = typeInformation.getType();
        try {
            E entity = this.createPersistentEntity(typeInformation);
            this.persistentEntities.put(entity.getTypeInformation(), entity);
            BeanInfo info = Introspector.getBeanInfo(type);
            final HashMap<String, PropertyDescriptor> descriptors = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                descriptors.put(descriptor.getName(), descriptor);
            }
            ReflectionUtils.doWithFields(type, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback((MutablePersistentEntity)entity){
                final /* synthetic */ MutablePersistentEntity val$entity;
                {
                    this.val$entity = mutablePersistentEntity;
                }

                public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                    TypeInformation nestedType;
                    PropertyDescriptor descriptor = (PropertyDescriptor)descriptors.get(field.getName());
                    ReflectionUtils.makeAccessible((Field)field);
                    Object property = AbstractMappingContext.this.createPersistentProperty(field, descriptor, this.val$entity, AbstractMappingContext.this.simpleTypeHolder);
                    if (property.isTransient()) {
                        return;
                    }
                    this.val$entity.addPersistentProperty(property);
                    if (property.isAssociation()) {
                        this.val$entity.addAssociation(property.getAssociation());
                    }
                    if (property.isIdProperty()) {
                        this.val$entity.setIdProperty(property);
                    }
                    if ((nestedType = AbstractMappingContext.this.getNestedTypeToAdd(property, this.val$entity)) != null) {
                        AbstractMappingContext.this.addPersistentEntity(nestedType);
                    }
                }
            }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

                public boolean matches(Field field) {
                    return !Modifier.isStatic(field.getModifiers()) && !UNMAPPED_FIELDS.contains(field.getName());
                }
            });
            entity.verify();
            if (null != this.applicationEventPublisher) {
                this.applicationEventPublisher.publishEvent(new MappingContextEvent(entity, typeInformation));
            }
            return entity;
        }
        catch (IntrospectionException e) {
            throw new MappingException(e.getMessage(), e);
        }
    }

    private TypeInformation<?> getNestedTypeToAdd(P property, PersistentEntity<?, P> entity) {
        if (entity.getType().equals(property.getRawType())) {
            return null;
        }
        TypeInformation<?> typeInformation = property.getTypeInformation();
        if (this.customSimpleTypes.contains(typeInformation.getType())) {
            return null;
        }
        if (property.isEntity()) {
            return typeInformation;
        }
        if (property.isCollection()) {
            return this.getTypeInformationIfNotSimpleType(this.getComponentTypeRecursively(typeInformation));
        }
        if (property.isMap()) {
            return this.getTypeInformationIfNotSimpleType(typeInformation.getMapValueType());
        }
        return null;
    }

    private TypeInformation<?> getComponentTypeRecursively(TypeInformation<?> typeInformation) {
        TypeInformation<?> componentType = typeInformation.getComponentType();
        if (componentType == null) {
            return null;
        }
        return componentType.isCollectionLike() ? this.getComponentTypeRecursively(componentType) : componentType;
    }

    private TypeInformation<?> getTypeInformationIfNotSimpleType(TypeInformation<?> information) {
        return information == null || this.simpleTypeHolder.isSimpleType(information.getType()) ? null : information;
    }

    protected abstract <T> E createPersistentEntity(TypeInformation<T> var1);

    protected abstract P createPersistentProperty(Field var1, PropertyDescriptor var2, E var3, SimpleTypeHolder var4);

    public void afterPropertiesSet() {
        for (Class<?> initialEntity : this.initialEntitySet) {
            this.addPersistentEntity(initialEntity);
        }
    }
}

