/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingContextAwareBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private String mappingContextBeanName = "mappingContext";
    private MappingContext<?, ?> mappingContext;

    public MappingContextAwareBeanPostProcessor() {
    }

    public MappingContextAwareBeanPostProcessor(MappingContext<?, ?> mappingContext) {
        this.mappingContext = mappingContext;
    }

    public String getMappingContextBeanName() {
        return this.mappingContextBeanName;
    }

    public void setMappingContextBeanName(String mappingContextBeanName) {
        this.mappingContextBeanName = mappingContextBeanName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof MappingContextAware) {
            if (null == this.mappingContext) {
                Map mappingContexts = this.applicationContext.getBeansOfType(MappingContext.class);
                if (mappingContexts.containsKey(this.mappingContextBeanName)) {
                    this.mappingContext = (MappingContext)mappingContexts.get(this.mappingContextBeanName);
                } else {
                    String firstBean = (String)mappingContexts.keySet().iterator().next();
                    this.mappingContext = (MappingContext)this.applicationContext.getBean(firstBean, MappingContext.class);
                }
            }
            ((MappingContextAware)bean).setMappingContext(this.mappingContext);
        }
        return bean;
    }
}

