/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.MutablePersistentEntity;
import org.springframework.data.mapping.model.PreferredConstructorDiscoverer;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPersistentEntity<T, P extends PersistentProperty<P>>
implements MutablePersistentEntity<T, P> {
    private final PreferredConstructor<T> preferredConstructor;
    private final TypeInformation<T> information;
    private final Set<P> properties;
    private final Set<Association<P>> associations;
    private P idProperty;

    public BasicPersistentEntity(TypeInformation<T> information) {
        this(information, null);
    }

    public BasicPersistentEntity(TypeInformation<T> information, Comparator<P> comparator) {
        Assert.notNull(information);
        this.information = information;
        this.preferredConstructor = new PreferredConstructorDiscoverer<T>(information).getConstructor();
        this.properties = comparator == null ? new HashSet() : new TreeSet<P>(comparator);
        this.associations = comparator == null ? new HashSet() : new TreeSet<P>(new AssociationComparator<P>(comparator));
    }

    @Override
    public PreferredConstructor<T> getPreferredConstructor() {
        return this.preferredConstructor;
    }

    @Override
    public String getName() {
        return this.getType().getName();
    }

    @Override
    public P getIdProperty() {
        return this.idProperty;
    }

    @Override
    public void setIdProperty(P property) {
        this.idProperty = property;
    }

    @Override
    public void addPersistentProperty(P property) {
        Assert.notNull(property);
        this.properties.add(property);
    }

    @Override
    public void addAssociation(Association<P> association) {
        this.associations.add(association);
    }

    @Override
    public P getPersistentProperty(String name) {
        for (PersistentProperty property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return (P)property;
        }
        return null;
    }

    @Override
    public Class<T> getType() {
        return this.information.getType();
    }

    @Override
    public TypeInformation<T> getTypeInformation() {
        return this.information;
    }

    @Override
    public void doWithProperties(PropertyHandler<P> handler) {
        Assert.notNull(handler);
        for (PersistentProperty property : this.properties) {
            if (property.isTransient() || property.isAssociation()) continue;
            handler.doWithPersistentProperty(property);
        }
    }

    @Override
    public void doWithAssociations(AssociationHandler<P> handler) {
        Assert.notNull(handler);
        for (Association<P> association : this.associations) {
            handler.doWithAssociation(association);
        }
    }

    @Override
    public void verify() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AssociationComparator<P extends PersistentProperty<P>>
    implements Comparator<Association<P>> {
        private final Comparator<P> delegate;

        public AssociationComparator(Comparator<P> delegate) {
            Assert.notNull(delegate);
            this.delegate = delegate;
        }

        @Override
        public int compare(Association<P> left, Association<P> right) {
            return this.delegate.compare(left.getInverse(), right.getInverse());
        }
    }
}

