/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferredConstructorDiscoverer<T> {
    private final ParameterNameDiscoverer nameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private PreferredConstructor<T> constructor;

    public PreferredConstructorDiscoverer(Class<T> type) {
        this(ClassTypeInformation.from(type));
    }

    protected PreferredConstructorDiscoverer(TypeInformation<T> owningType) {
        boolean noArgConstructorFound = false;
        int numberOfArgConstructors = 0;
        Class<T> rawOwningType = owningType.getType();
        for (Constructor<?> constructor : rawOwningType.getDeclaredConstructors()) {
            PreferredConstructor<T> preferredConstructor = this.buildPreferredConstructor(constructor, owningType);
            if (preferredConstructor.isExplicitlyAnnotated()) {
                this.constructor = preferredConstructor;
                return;
            }
            if (this.constructor == null || preferredConstructor.isNoArgConstructor()) {
                this.constructor = preferredConstructor;
            }
            if (preferredConstructor.isNoArgConstructor()) {
                noArgConstructorFound = true;
                continue;
            }
            ++numberOfArgConstructors;
        }
        if (!noArgConstructorFound && numberOfArgConstructors > 1) {
            throw new IllegalArgumentException(String.format("Multiple constructors with arguments found in class %s! Annotate one with @PersistenceConstructor explicitly to select it to be used in persistence operations.", rawOwningType.getName()));
        }
    }

    private PreferredConstructor<T> buildPreferredConstructor(Constructor<?> constructor, TypeInformation<T> typeInformation) {
        List<TypeInformation<?>> parameterTypes = typeInformation.getParameterTypes(constructor);
        if (parameterTypes.isEmpty()) {
            return new PreferredConstructor(constructor, new PreferredConstructor.Parameter[0]);
        }
        String[] parameterNames = this.nameDiscoverer.getParameterNames(constructor);
        PreferredConstructor.Parameter[] parameters = new PreferredConstructor.Parameter[parameterTypes.size()];
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            String name = parameterNames == null ? null : parameterNames[i];
            TypeInformation<?> type = parameterTypes.get(i);
            Annotation[] annotations = parameterAnnotations[i];
            parameters[i] = new PreferredConstructor.Parameter(name, type, annotations);
        }
        return new PreferredConstructor(constructor, parameters);
    }

    public PreferredConstructor<T> getConstructor() {
        return this.constructor;
    }
}

