/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.persistence;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.persistence.EntityInstantiator;
import org.springframework.data.persistence.StateBackedCreator;
import org.springframework.data.persistence.StateProvider;
import org.springframework.util.ClassUtils;
import sun.reflect.ReflectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConstructorEntityInstantiator<BACKING_INTERFACE, STATE>
implements EntityInstantiator<BACKING_INTERFACE, STATE> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Map<Class<? extends BACKING_INTERFACE>, StateBackedCreator<? extends BACKING_INTERFACE, STATE>> cache = new HashMap<Class<? extends BACKING_INTERFACE>, StateBackedCreator<? extends BACKING_INTERFACE, STATE>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends BACKING_INTERFACE> T createEntityFromState(STATE n, Class<T> c) {
        try {
            StateBackedCreator<Object, Object> creator = this.cache.get(c);
            if (creator != null) {
                return (T)creator.create(n, c);
            }
            Map<Class<? extends BACKING_INTERFACE>, StateBackedCreator<? extends BACKING_INTERFACE, STATE>> map = this.cache;
            synchronized (map) {
                creator = this.cache.get(c);
                if (creator != null) {
                    return (T)creator.create(n, c);
                }
                Class<?> stateClass = n.getClass();
                creator = this.createInstantiator(c, stateClass);
                this.cache.put(c, creator);
                return (T)creator.create(n, c);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getTargetException());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setInstantiators(Map<Class<? extends BACKING_INTERFACE>, StateBackedCreator<? extends BACKING_INTERFACE, STATE>> instantiators) {
        this.cache.putAll(instantiators);
    }

    protected <T extends BACKING_INTERFACE> StateBackedCreator<T, STATE> createInstantiator(Class<T> type, Class<STATE> stateType) {
        StateBackedCreator<T, STATE> creator = this.stateTakingConstructorInstantiator(type, stateType);
        if (creator != null) {
            return creator;
        }
        creator = this.emptyConstructorStateSettingInstantiator(type, stateType);
        if (creator != null) {
            return creator;
        }
        return this.createFailingInstantiator(stateType);
    }

    protected <T extends BACKING_INTERFACE> StateBackedCreator<T, STATE> createFailingInstantiator(final Class<STATE> stateType) {
        return new StateBackedCreator<T, STATE>(){

            @Override
            public T create(STATE n, Class<T> c) throws Exception {
                throw new IllegalArgumentException(AbstractConstructorEntityInstantiator.this.getFailingMessageForClass(c, stateType));
            }
        };
    }

    protected String getFailingMessageForClass(Class<?> entityClass, Class<STATE> stateClass) {
        return this.getClass().getSimpleName() + ": entity " + entityClass + " must have either a constructor taking [" + stateClass + "] or a no-arg constructor and state setter.";
    }

    private <T extends BACKING_INTERFACE> StateBackedCreator<T, STATE> emptyConstructorStateSettingInstantiator(Class<T> type, Class<STATE> stateType) {
        final Constructor<T> constructor = this.getNoArgConstructor(type);
        if (constructor == null) {
            return null;
        }
        this.log.info((Object)("Using " + type + " no-arg constructor"));
        return new StateBackedCreator<T, STATE>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T create(STATE state, Class<T> c) throws Exception {
                try {
                    StateProvider.setUnderlyingState(state);
                    Object newInstance = constructor.newInstance(new Object[0]);
                    AbstractConstructorEntityInstantiator.this.setState(newInstance, state);
                    Object t = newInstance;
                    return t;
                }
                finally {
                    StateProvider.retrieveState();
                }
            }
        };
    }

    protected <T extends BACKING_INTERFACE> StateBackedCreator<T, STATE> createWithoutConstructorInvocation(final Class<T> type, Class<STATE> stateType) {
        ReflectionFactory rf = ReflectionFactory.getReflectionFactory();
        Constructor<Object> objectConstructor = this.getDeclaredConstructor(Object.class);
        final Constructor<?> serializationConstructor = rf.newConstructorForSerialization(type, objectConstructor);
        return new StateBackedCreator<T, STATE>(){

            @Override
            public T create(STATE state, Class<T> c) throws Exception {
                Object result = type.cast(serializationConstructor.newInstance(new Object[0]));
                AbstractConstructorEntityInstantiator.this.setState(result, state);
                return result;
            }
        };
    }

    protected <T extends BACKING_INTERFACE> Constructor<T> getNoArgConstructor(Class<T> type) {
        Constructor constructor = ClassUtils.getConstructorIfAvailable(type, (Class[])new Class[0]);
        if (constructor != null) {
            return constructor;
        }
        return this.getDeclaredConstructor(type);
    }

    protected <T extends BACKING_INTERFACE> StateBackedCreator<T, STATE> stateTakingConstructorInstantiator(Class<T> type, Class<STATE> stateType) {
        Class<?> stateInterface = stateType.getInterfaces()[0];
        final Constructor constructor = ClassUtils.getConstructorIfAvailable(type, (Class[])new Class[]{stateInterface});
        if (constructor == null) {
            return null;
        }
        this.log.info((Object)("Using " + type + " constructor taking " + stateInterface));
        return new StateBackedCreator<T, STATE>(){

            @Override
            public T create(STATE n, Class<T> c) throws Exception {
                return constructor.newInstance(n);
            }
        };
    }

    protected <T> Constructor<T> getDeclaredConstructor(Class<T> c) {
        try {
            Constructor<T> declaredConstructor = c.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            return declaredConstructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    protected abstract void setState(BACKING_INTERFACE var1, STATE var2);
}

