/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ReaderContext;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AbstractTypeHierarchyTraversingFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.RepositoryDefinition;
import org.springframework.data.repository.config.GlobalRepositoryConfigInformation;
import org.springframework.data.repository.config.NamedQueriesBeanDefinitionParser;
import org.springframework.data.repository.config.SingleRepositoryConfigInformation;
import org.springframework.data.repository.config.TypeFilterParser;
import org.springframework.data.repository.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryConfigDefinitionParser<S extends GlobalRepositoryConfigInformation<T>, T extends SingleRepositoryConfigInformation<S>>
implements BeanDefinitionParser {
    private static final Log LOG = LogFactory.getLog(AbstractRepositoryConfigDefinitionParser.class);
    private static final String REPOSITORY_INTERFACE_POST_PROCESSOR = "org.springframework.data.repository.core.support.RepositoryInterfaceAwareBeanPostProcessor";

    public BeanDefinition parse(Element element, ParserContext parser) {
        try {
            S configContext = this.getGlobalRepositoryConfigInformation(element);
            if (configContext.configureManually()) {
                this.doManualConfiguration(configContext, parser);
            } else {
                this.doAutoConfiguration(configContext, parser);
            }
            Object beanSource = parser.extractSource((Object)element);
            this.registerBeansForRoot(parser.getRegistry(), beanSource);
        }
        catch (RuntimeException e) {
            this.handleError(e, element, (ReaderContext)parser.getReaderContext());
        }
        return null;
    }

    private void doAutoConfiguration(S config, ParserContext parser) {
        LOG.debug((Object)"Triggering auto repository detection");
        ResourceLoader resourceLoader = parser.getReaderContext().getResourceLoader();
        Set<String> repositoryInterfaces = this.getRepositoryInterfacesForAutoConfig(config, resourceLoader, (ReaderContext)parser.getReaderContext());
        for (String repositoryInterface : repositoryInterfaces) {
            this.registerGenericRepositoryFactoryBean(parser, config.getAutoconfigRepositoryInformation(repositoryInterface));
        }
    }

    private Set<String> getRepositoryInterfacesForAutoConfig(S config, ResourceLoader loader, ReaderContext reader) {
        RepositoryComponentProvider scanner = new RepositoryComponentProvider(config.getRepositoryBaseInterface());
        scanner.setResourceLoader(loader);
        TypeFilterParser parser = new TypeFilterParser(loader.getClassLoader(), reader);
        parser.parseFilters(config.getSource(), scanner);
        Set findCandidateComponents = scanner.findCandidateComponents(config.getBasePackage());
        HashSet<String> interfaceNames = new HashSet<String>();
        for (BeanDefinition definition : findCandidateComponents) {
            interfaceNames.add(definition.getBeanClassName());
        }
        return interfaceNames;
    }

    protected abstract S getGlobalRepositoryConfigInformation(Element var1);

    private void doManualConfiguration(S context, ParserContext parser) {
        LOG.debug((Object)"Triggering manual repository detection");
        for (SingleRepositoryConfigInformation repositoryContext : context.getSingleRepositoryConfigInformations()) {
            this.registerGenericRepositoryFactoryBean(parser, repositoryContext);
        }
    }

    private void handleError(Exception e, Element source, ReaderContext reader) {
        reader.error(e.getMessage(), reader.extractSource((Object)source), e.getCause());
    }

    private void registerGenericRepositoryFactoryBean(ParserContext parser, T context) {
        try {
            String customImplementationBeanName;
            Object beanSource = parser.extractSource((Object)context.getSource());
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)context.getRepositoryFactoryBeanClassName());
            builder.addPropertyValue("repositoryInterface", (Object)context.getInterfaceName());
            builder.addPropertyValue("queryLookupStrategyKey", (Object)context.getQueryLookupStrategyKey());
            builder.addPropertyValue("namedQueries", (Object)new NamedQueriesBeanDefinitionParser(context.getNamedQueriesLocation()).parse(context.getSource(), parser));
            String transactionManagerRef = context.getTransactionManagerRef();
            if (StringUtils.hasText((String)transactionManagerRef)) {
                builder.addPropertyValue("transactionManager", (Object)transactionManagerRef);
            }
            if ((customImplementationBeanName = this.registerCustomImplementation(context, parser, beanSource)) != null) {
                builder.addPropertyReference("customImplementation", customImplementationBeanName);
            }
            this.postProcessBeanDefinition(context, builder, parser.getRegistry(), beanSource);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            beanDefinition.setSource(beanSource);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Registering repository: " + context.getBeanId() + " - Interface: " + context.getInterfaceName() + " - Factory: " + context.getRepositoryFactoryBeanClassName() + ", - Custom implementation: " + customImplementationBeanName));
            }
            BeanComponentDefinition definition = new BeanComponentDefinition((BeanDefinition)beanDefinition, context.getBeanId());
            parser.registerBeanComponent(definition);
        }
        catch (RuntimeException e) {
            this.handleError(e, context.getSource(), (ReaderContext)parser.getReaderContext());
        }
    }

    protected void postProcessBeanDefinition(T context, BeanDefinitionBuilder builder, BeanDefinitionRegistry registry, Object beanSource) {
    }

    private String registerCustomImplementation(T config, ParserContext parser, Object source) {
        String beanName = config.getImplementationBeanName();
        if (parser.getRegistry().containsBeanDefinition(beanName)) {
            return beanName;
        }
        if (config.autodetectCustomImplementation()) {
            AbstractBeanDefinition beanDefinition = this.detectCustomImplementation(config, parser);
            if (null == beanDefinition) {
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Registering custom repository implementation: " + config.getImplementationBeanName() + " " + beanDefinition.getBeanClassName()));
            }
            beanDefinition.setSource(source);
            parser.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDefinition, beanName));
        } else {
            beanName = config.getCustomImplementationRef();
        }
        return beanName;
    }

    private AbstractBeanDefinition detectCustomImplementation(T config, ParserContext parser) {
        Pattern pattern = Pattern.compile(".*" + config.getImplementationClassName());
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.setResourceLoader(parser.getReaderContext().getResourceLoader());
        provider.addIncludeFilter((TypeFilter)new RegexPatternTypeFilter(pattern));
        Set definitions = provider.findCandidateComponents(config.getBasePackage());
        return 0 == definitions.size() ? null : (AbstractBeanDefinition)definitions.iterator().next();
    }

    protected void registerBeansForRoot(BeanDefinitionRegistry registry, Object source) {
        AbstractBeanDefinition definition = BeanDefinitionBuilder.rootBeanDefinition((String)REPOSITORY_INTERFACE_POST_PROCESSOR).getBeanDefinition();
        AbstractRepositoryConfigDefinitionParser.registerWithSourceAndGeneratedBeanName(registry, definition, source);
    }

    protected static boolean hasBean(Class<?> type, BeanDefinitionRegistry registry) {
        String name = String.format("%s%s0", type.getName(), "#");
        return registry.containsBeanDefinition(name);
    }

    protected static String registerWithSourceAndGeneratedBeanName(BeanDefinitionRegistry registry, AbstractBeanDefinition bean, Object source) {
        bean.setSource(source);
        String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)bean, (BeanDefinitionRegistry)registry);
        registry.registerBeanDefinition(beanName, (BeanDefinition)bean);
        return beanName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RepositoryComponentProvider
    extends ClassPathScanningCandidateComponentProvider {
        public RepositoryComponentProvider(Class<?> repositoryInterface) {
            super(false);
            this.addIncludeFilter((TypeFilter)new InterfaceTypeFilter(repositoryInterface));
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(RepositoryDefinition.class, true, true));
            this.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(NoRepositoryBean.class));
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            boolean isNonRepositoryInterface = !ClassUtils.isGenericRepositoryInterface(beanDefinition.getBeanClassName());
            boolean isTopLevelType = !beanDefinition.getMetadata().hasEnclosingClass();
            return isNonRepositoryInterface && isTopLevelType;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class AnnotationTypeFilter
        extends AbstractTypeHierarchyTraversingFilter {
            private final Class<? extends Annotation> annotationType;
            private final boolean considerMetaAnnotations;

            public AnnotationTypeFilter(Class<? extends Annotation> annotationType) {
                this(annotationType, true);
            }

            public AnnotationTypeFilter(Class<? extends Annotation> annotationType, boolean considerMetaAnnotations) {
                this(annotationType, considerMetaAnnotations, false);
            }

            public AnnotationTypeFilter(Class<? extends Annotation> annotationType, boolean considerMetaAnnotations, boolean considerInterfaces) {
                super(annotationType.isAnnotationPresent(Inherited.class), considerInterfaces);
                this.annotationType = annotationType;
                this.considerMetaAnnotations = considerMetaAnnotations;
            }

            protected boolean matchSelf(MetadataReader metadataReader) {
                AnnotationMetadata metadata = metadataReader.getAnnotationMetadata();
                return metadata.hasAnnotation(this.annotationType.getName()) || this.considerMetaAnnotations && metadata.hasMetaAnnotation(this.annotationType.getName());
            }

            protected Boolean matchSuperClass(String superClassName) {
                if (Object.class.getName().equals(superClassName)) {
                    return Boolean.FALSE;
                }
                if (superClassName.startsWith("java.")) {
                    try {
                        Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(superClassName);
                        return clazz.getAnnotation(this.annotationType) != null;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                return null;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class InterfaceTypeFilter
        extends AssignableTypeFilter {
            public InterfaceTypeFilter(Class<?> targetType) {
                super(targetType);
            }

            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                return metadataReader.getClassMetadata().isInterface() && super.match(metadataReader, metadataReaderFactory);
            }
        }
    }
}

