/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import org.springframework.data.repository.RepositoryDefinition;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationRepositoryMetadata
implements RepositoryMetadata {
    private static final String NO_ANNOTATION_FOUND = String.format("Interface must be annotated with @%s!", RepositoryDefinition.class.getName());
    private final Class<?> repositoryInterface;

    public AnnotationRepositoryMetadata(Class<?> repositoryInterface) {
        Assert.notNull(repositoryInterface, (String)"Repository interface must not be null!");
        Assert.isTrue((boolean)repositoryInterface.isAnnotationPresent(RepositoryDefinition.class), (String)NO_ANNOTATION_FOUND);
        this.repositoryInterface = repositoryInterface;
    }

    @Override
    public Class<?> getIdClass() {
        RepositoryDefinition annotation = this.repositoryInterface.getAnnotation(RepositoryDefinition.class);
        return annotation == null ? null : annotation.idClass();
    }

    @Override
    public Class<?> getDomainClass() {
        RepositoryDefinition annotation = this.repositoryInterface.getAnnotation(RepositoryDefinition.class);
        return annotation == null ? null : annotation.domainClass();
    }

    @Override
    public Class<?> getRepositoryInterface() {
        return this.repositoryInterface;
    }
}

