/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import org.springframework.core.GenericTypeResolver;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryMetadata
implements RepositoryMetadata {
    private final Class<?> repositoryInterface;

    public DefaultRepositoryMetadata(Class<?> repositoryInterface) {
        Assert.notNull(repositoryInterface);
        Assert.isTrue((boolean)Repository.class.isAssignableFrom(repositoryInterface));
        this.repositoryInterface = repositoryInterface;
    }

    @Override
    public Class<?> getRepositoryInterface() {
        return this.repositoryInterface;
    }

    @Override
    public Class<?> getDomainClass() {
        Class[] arguments = GenericTypeResolver.resolveTypeArguments(this.repositoryInterface, Repository.class);
        return arguments == null ? null : arguments[0];
    }

    @Override
    public Class<?> getIdClass() {
        Class[] arguments = GenericTypeResolver.resolveTypeArguments(this.repositoryInterface, Repository.class);
        return arguments == null ? null : arguments[1];
    }
}

