/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RepositoryInterfaceAwareBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanFactoryAware {
    private static final Class<?> REPOSITORY_TYPE = RepositoryFactoryBeanSupport.class;
    private ConfigurableListableBeanFactory context;

    RepositoryInterfaceAwareBeanPostProcessor() {
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.context = (ConfigurableListableBeanFactory)beanFactory;
        }
    }

    public Class<?> predictBeanType(Class<?> beanClass, String beanName) {
        if (null == this.context || !REPOSITORY_TYPE.isAssignableFrom(beanClass)) {
            return null;
        }
        BeanDefinition definition = this.context.getBeanDefinition(beanName);
        PropertyValue value = definition.getPropertyValues().getPropertyValue("repositoryInterface");
        return this.getClassForPropertyValue(value);
    }

    private Class<?> getClassForPropertyValue(PropertyValue propertyValue) {
        Object value = propertyValue.getValue();
        String className = null;
        if (value instanceof TypedStringValue) {
            className = ((TypedStringValue)value).getValue();
        } else if (value instanceof String) {
            className = (String)value;
        } else {
            if (value instanceof Class) {
                return (Class)value;
            }
            return null;
        }
        try {
            return ClassUtils.resolveClassName((String)className, (ClassLoader)RepositoryInterfaceAwareBeanPostProcessor.class.getClassLoader());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

