/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.Arrays;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Param;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Parameter {
    static final List<Class<?>> TYPES = Arrays.asList(Pageable.class, Sort.class);
    private static final String PARAM_ON_SPECIAL = String.format("You must not user @%s on a parameter typed %s or %s", Param.class.getSimpleName(), Pageable.class.getSimpleName(), Sort.class.getSimpleName());
    private static final String NAMED_PARAMETER_TEMPLATE = ":%s";
    private static final String POSITION_PARAMETER_TEMPLATE = "?%s";
    private final Class<?> type;
    private final Parameters parameters;
    private final int index;
    private final String name;

    Parameter(Class<?> type, Parameters parameters, int index, String name) {
        Assert.notNull(type);
        Assert.notNull((Object)parameters);
        this.parameters = parameters;
        this.index = index;
        this.type = type;
        this.name = name;
        if (this.isSpecialParameter() && this.isNamedParameter()) {
            throw new IllegalArgumentException(PARAM_ON_SPECIAL);
        }
    }

    boolean isFirst() {
        return this.index == 0;
    }

    public Parameter getNext() {
        return this.parameters.getParameter(this.index + 1);
    }

    Parameter getPrevious() {
        return this.parameters.getParameter(this.index - 1);
    }

    public boolean isSpecialParameter() {
        return TYPES.contains(this.type);
    }

    public boolean isBindable() {
        return !this.isSpecialParameter();
    }

    public String getPlaceholder() {
        if (this.isNamedParameter()) {
            return String.format(NAMED_PARAMETER_TEMPLATE, this.getName());
        }
        return String.format(POSITION_PARAMETER_TEMPLATE, this.getIndex());
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isNamedParameter() {
        return !this.isSpecialParameter() && this.getName() != null;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String toString() {
        return String.format("%s:%s", this.isNamedParameter() ? this.getName() : "#" + this.index, this.type.getName());
    }

    boolean isPageable() {
        return Pageable.class.isAssignableFrom(this.type);
    }

    boolean isSort() {
        return Sort.class.isAssignableFrom(this.type);
    }
}

