/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.Iterator;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.Assert;

public class ParametersParameterAccessor
implements ParameterAccessor {
    private final Parameters parameters;
    private final Object[] values;

    public ParametersParameterAccessor(Parameters parameters, Object[] values) {
        Assert.notNull((Object)parameters);
        Assert.notNull((Object)values);
        Assert.isTrue((parameters.getNumberOfParameters() == values.length ? 1 : 0) != 0, (String)"Invalid number of parameters given!");
        this.parameters = parameters;
        this.values = (Object[])values.clone();
    }

    public Pageable getPageable() {
        if (!this.parameters.hasPageableParameter()) {
            return null;
        }
        return (Pageable)this.values[this.parameters.getPageableIndex()];
    }

    public Sort getSort() {
        if (this.parameters.hasSortParameter()) {
            return (Sort)this.values[this.parameters.getSortIndex()];
        }
        if (this.parameters.hasPageableParameter() && this.getPageable() != null) {
            return this.getPageable().getSort();
        }
        return null;
    }

    public Object getBindableValue(int index) {
        return this.values[this.parameters.getBindableParameter(index).getIndex()];
    }

    public BindableParameterIterator iterator() {
        return new BindableParameterIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BindableParameterIterator
    implements Iterator<Object> {
        private int currentIndex = 0;

        private BindableParameterIterator() {
        }

        @Override
        public Object next() {
            return ParametersParameterAccessor.this.getBindableValue(this.currentIndex++);
        }

        @Override
        public boolean hasNext() {
            return ParametersParameterAccessor.this.values.length > this.currentIndex;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

